/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarBodyBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterRequestBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterResponseBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;

public class XmlAndJSONSchemasReferencedByDescriptorMustBeWellFormedRule
extends DescriptorValidationRule {
    public XmlAndJSONSchemasReferencedByDescriptorMustBeWellFormedRule() {
        super("All XSD and JSON schemas referenced by the descriptor must be well formed.", "All Schema files referenced by the descriptor (as outputType, inputType or typeSchema) must be a well formed JSON or XML file.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationsResults = new ArrayList<ValidationResult>();
        List<Triple<String, String, DescriptorElement>> invalidSchemaReferences = this.getInvalidTypeSchemasFromDescriptor(connectorDescriptor);
        for (Triple<String, String, DescriptorElement> schemaReference : invalidSchemaReferences) {
            String detail = this.getDetailedElementDescription(schemaReference);
            DescriptorElementLocation location = ((DescriptorElement)schemaReference.getRight()).getLocation();
            validationsResults.add(this.getValidationError(detail, location));
        }
        return validationsResults;
    }

    private ValidationResult getValidationError(String detail, DescriptorElementLocation location) {
        return new ValidationResult(this, detail, location);
    }

    private String getDetailedElementDescription(Triple<String, String, DescriptorElement> schemaReference) {
        StringBuilder mainElement = new StringBuilder();
        StringBuilder specificDescription = new StringBuilder();
        DescriptorElement descriptor = (DescriptorElement)schemaReference.getRight();
        String mainElementName = (String)schemaReference.getMiddle();
        String specificName = (String)schemaReference.getLeft();
        if (descriptor instanceof TriggerDescriptor || descriptor instanceof TriggerParameterDescriptor) {
            mainElement.append("trigger '").append(mainElementName.toUpperCase()).append("'");
            if (descriptor instanceof TriggerParameterDescriptor) {
                specificDescription.append(", trigger parameter '").append(specificName.toUpperCase()).append("'");
            }
        } else {
            mainElement.append("operation '").append(mainElementName.toUpperCase()).append("'");
            if (descriptor instanceof OperationDescriptor) {
                specificDescription.append(", endpoint '").append(specificName.toUpperCase());
            } else {
                specificDescription.append(", property '").append(specificName.toUpperCase()).append("'");
            }
        }
        return String.format("The schema file declared in the %1$s%2$s is not a well formed JSON or XML file.", mainElement, specificDescription);
    }

    private List<Triple<String, String, DescriptorElement>> getInvalidTypeSchemasFromDescriptor(ConnectorDescriptor connectorDescriptor) {
        ArrayList<Triple<String, String, DescriptorElement>> allInvalidSchemas = new ArrayList<Triple<String, String, DescriptorElement>>();
        allInvalidSchemas.addAll(this.getInvalidOperationAdaptersSchemasFromConnectorDescriptor(connectorDescriptor));
        allInvalidSchemas.addAll(this.getInvalidOperationSchemasFromConnectorDescriptor(connectorDescriptor));
        allInvalidSchemas.addAll(this.getInvalidTriggerSchemasFromConnectorDescriptor(connectorDescriptor));
        return allInvalidSchemas;
    }

    private List<Triple<String, String, DescriptorElement>> getInvalidTriggerSchemasFromConnectorDescriptor(ConnectorDescriptor connectorDescriptor) {
        ArrayList<Triple<String, String, DescriptorElement>> invalidTriggerSchemas = new ArrayList<Triple<String, String, DescriptorElement>>();
        List<TriggerDescriptor> triggers = this.getTriggersFromConnectorDescriptor(connectorDescriptor);
        for (TriggerDescriptor trigger : triggers) {
            String triggerName = trigger.getName();
            if (trigger.getOutputTypeSchema() != null && trigger.getOutputTypeSchema().getContent() != null && this.isInvalidSchema(trigger.getOutputTypeSchema().getContent())) {
                invalidTriggerSchemas.add((Triple<String, String, DescriptorElement>)Triple.of((Object)triggerName, (Object)triggerName, (Object)trigger));
            }
            trigger.getParameters().stream().filter(Objects::nonNull).filter(x -> x.getInputType() != null && x.getInputType().getContent() != null && this.isInvalidSchema(x.getInputType().getContent())).forEach(x -> invalidTriggerSchemas.add(Triple.of((Object)x.getName(), (Object)triggerName, (Object)x)));
        }
        return invalidTriggerSchemas;
    }

    private List<Triple<String, String, DescriptorElement>> getInvalidOperationSchemasFromConnectorDescriptor(ConnectorDescriptor connectorDescriptor) {
        ArrayList<Triple<String, String, DescriptorElement>> invalidOperationSchemas = new ArrayList<Triple<String, String, DescriptorElement>>();
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            String endpointPath = endpoint.getPath().toUpperCase();
            for (OperationDescriptor operation : endpoint.getOperations()) {
                if (operation.getOutputTypeSchema() != null && operation.getOutputTypeSchema().getContent() != null && this.isInvalidSchema(operation.getOutputTypeSchema().getContent())) {
                    invalidOperationSchemas.add((Triple<String, String, DescriptorElement>)Triple.of((Object)(endpointPath + "' (OUTPUT)"), (Object)operation.getMethod(), (Object)operation));
                }
                if (operation.getInputTypeSchema() == null || operation.getInputTypeSchema().getContent() == null || !this.isInvalidSchema(operation.getInputTypeSchema().getContent())) continue;
                invalidOperationSchemas.add((Triple<String, String, DescriptorElement>)Triple.of((Object)(endpointPath + "' (INPUT)"), (Object)operation.getMethod(), (Object)operation));
            }
        }
        return invalidOperationSchemas;
    }

    private List<Triple<String, String, DescriptorElement>> getInvalidOperationAdaptersSchemasFromConnectorDescriptor(ConnectorDescriptor connectorDescriptor) {
        ArrayList<Triple<String, String, DescriptorElement>> invalidOpAdaptersSchemas = new ArrayList<Triple<String, String, DescriptorElement>>();
        List<OperationAdapterDescriptor> operationAdapters = this.getOpAdaptersDescriptorStream(connectorDescriptor);
        for (OperationAdapterDescriptor operationAdapter : operationAdapters) {
            AuxiliarBodyBindingDescriptor bodyBinding;
            AuxiliarParameterResponseBindingsDescriptor responseBindings;
            String operationName = operationAdapter.getDisplayName();
            for (Object parameter : operationAdapter.getParameters()) {
                if (parameter == null || parameter.getInputType() == null || parameter.getInputType().getContent() == null || !this.isInvalidSchema(parameter.getInputType().getContent())) continue;
                invalidOpAdaptersSchemas.add((Triple<String, String, DescriptorElement>)Triple.of((Object)parameter.getName(), (Object)operationName, (Object)parameter));
            }
            AuxiliarParameterRequestBindingsDescriptor requestBindings = operationAdapter.getRequestBindings();
            if (requestBindings != null) {
                Object parameter;
                parameter = requestBindings.getQueryParameters().iterator();
                while (parameter.hasNext()) {
                    AuxiliarParameterBindingDescriptor parameterBinding = (AuxiliarParameterBindingDescriptor)parameter.next();
                    if (parameterBinding == null || parameterBinding.getInputType() == null || parameterBinding.getInputType().getContent() == null || !this.isInvalidSchema(parameterBinding.getInputType().getContent())) continue;
                    invalidOpAdaptersSchemas.add((Triple<String, String, DescriptorElement>)Triple.of((Object)(parameterBinding.getName() + "request binding"), (Object)operationName, (Object)parameterBinding));
                }
            }
            if ((responseBindings = operationAdapter.getResponseBindings()) == null || responseBindings.getBodyBinding() == null || (bodyBinding = responseBindings.getBodyBinding()).getTypeSchema() == null || bodyBinding.getTypeSchema().getContent() == null || !this.isInvalidSchema(bodyBinding.getTypeSchema().getContent())) continue;
            invalidOpAdaptersSchemas.add((Triple<String, String, DescriptorElement>)Triple.of((Object)"response binding", (Object)operationName, (Object)bodyBinding));
        }
        return invalidOpAdaptersSchemas;
    }

    private boolean isInvalidSchema(String schemaString) {
        return !ValidationUtils.isWellFormedJSON(schemaString) && !ValidationUtils.isWellFormedXML(schemaString);
    }

    private List<TriggerDescriptor> getTriggersFromConnectorDescriptor(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getTriggers().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<OperationAdapterDescriptor> getOpAdaptersDescriptorStream(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getOperationAdapterDescriptors().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

