/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.NativeOperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DynamicOperationParametersMustNotBeTypedRule extends DescriptorValidationRule {

  public DynamicOperationParametersMustNotBeTypedRule() {
    super("Dynamic parameters must not have type",
          "Any parameter declared in a operation with 'mule-TypeResolver' must not have 'type' or 'typeSchema' property.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    List<ValidationResult> validationResults = new ArrayList<>();
    for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
      if (!(operationAdapterDescriptor instanceof NativeOperationAdapterDescriptor)) {
        for (AuxiliarParameterDescriptor auxiliarParameterDescriptor : operationAdapterDescriptor.getParameters()) {
          if (auxiliarParameterDescriptor.getMuleTypeResolver() != null
              && (auxiliarParameterDescriptor.getDataType() != null || auxiliarParameterDescriptor.getInputType() != null)) {
            validationResults.add(getValidationError(operationAdapterDescriptor, auxiliarParameterDescriptor));
          }
        }
      }
    }
    return validationResults;
  }

  private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor,
                                              AuxiliarParameterDescriptor auxiliarParameterDescriptor) {
    return new ValidationResult(this,
                                "Operation: '" + operationAdapterDescriptor.getDisplayName() + "' has one parameter: '"
                                    + auxiliarParameterDescriptor.getName() + "' that has 'mule-TypeResolver' and is typed",
                                auxiliarParameterDescriptor.getLocation());
  }
}
