/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils.getValueProviderDescriptors;
import static org.apache.commons.lang3.StringUtils.EMPTY;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class ValueProviderMustHaveRequestOrScriptDefinitionRule extends DescriptorValidationRule {

  public ValueProviderMustHaveRequestOrScriptDefinitionRule() {
    super("Invalid Value Provider definition.",
          EMPTY,
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    final List<ValidationResult> validationResults = new ArrayList<>();

    ValueProviderDefinitionDescriptor valueProviderDefinitionDescriptor;
    for (ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor> valueProviderDescriptor : getValueProviderDescriptors(connectorDescriptor)) {
      if (valueProviderDescriptor instanceof ResolverDefinitionDescriptor) {
        valueProviderDefinitionDescriptor = (ValueProviderDefinitionDescriptor) valueProviderDescriptor;
      } else {
        valueProviderDefinitionDescriptor =
            ((ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>) valueProviderDescriptor).getDeclaration()
                .getDefinition();
      }

      if (isInvalidValueProviderDefinition(valueProviderDefinitionDescriptor)) {
        validationResults.add(getValidationError(valueProviderDefinitionDescriptor));
      }

    }

    return validationResults;
  }

  private boolean isInvalidValueProviderDefinition(ValueProviderDefinitionDescriptor valueProviderDefinitionDescriptor) {
    if (isNotBlank(valueProviderDefinitionDescriptor.getFqn())) {
      return false;
    }
    return (valueProviderDefinitionDescriptor.getRequest() == null && valueProviderDefinitionDescriptor.getScript() == null) ||
        (valueProviderDefinitionDescriptor.getRequest() != null && valueProviderDefinitionDescriptor.getScript() != null);
  }


  private ValidationResult getValidationError(ValueProviderDefinitionDescriptor valueProviderDefinitionDescriptor) {
    return new ValidationResult(this,
                                "Value Provider must have 'request' or 'script' definition.",
                                valueProviderDefinitionDescriptor.getLocation());
  }
}
