/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.connectormodelbuilder;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public abstract class ConnectorModelBuilderPropertyCannotBeOverridenRule extends DescriptorConnectorModelBuilderValidationRule {

  public ConnectorModelBuilderPropertyCannotBeOverridenRule() {
    super("Property not overrideable",
          "Cannot set a new value for this property once set",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor,
                                         ConnectorModelBuilder connectorModelBuilder) {

    List<ValidationResult> validationResults = new ArrayList<>();
    if (getNotOverridablePropertyValue(connectorModelBuilder) != null && getPropertyValueToSet(connectorDescriptor) != null) {
      validationResults.add(new ValidationResult(this, getNotOverridablePropertyName() +
          " cannot be overridden, this is a bug", connectorDescriptor.getLocation()));
    }
    return validationResults;
  }

  protected abstract Object getNotOverridablePropertyValue(ConnectorModelBuilder connectorModelBuilder);

  protected abstract Object getPropertyValueToSet(ConnectorDescriptor connectorDescriptor);

  protected abstract String getNotOverridablePropertyName();

}
