/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OperationNameMustBeFriendlyRule
extends ConnectorModelValidationRule {
    public OperationNameMustBeFriendlyRule() {
        super("Operation display name seems not to be user friendly.", "The display name should be a human readable name separated with spaces.", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        return connectorModel.getOperations().stream().filter(op -> StringUtils.isBlank((CharSequence)op.getFqn())).filter(x -> !NamingUtil.isFriendlyName((String)x.getDisplayName())).map(this::getValidationError).collect(Collectors.toList());
    }

    private ValidationResult getValidationError(ConnectorOperation connectorOperation) {
        String detail = String.format("Operation with PATH: %s and METHOD: %s display name is '%s' and it is not friendly.", connectorOperation.getPath(), connectorOperation.getHttpMethod().name(), connectorOperation.getDisplayName());
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }
}

