/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.NativeOperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.List;
import java.util.stream.Collectors;

public class DescriptorParamsShouldBeTypedRule
extends DescriptorValidationRule {
    public DescriptorParamsShouldBeTypedRule() {
        super("Descriptor parameters must be typed", "Any parameter declared in the connector descriptor must be typed using either the 'type' or 'typeSchema' property.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getOperationAdapterDescriptors().stream().filter(oad -> !(oad instanceof NativeOperationAdapterDescriptor)).filter(oad -> oad.getParameters().stream().filter(p -> p.getMuleTypeResolver() == null).anyMatch(p -> p.getDataType() == null && p.getInputType() == null)).map(this::getValidationError).collect(Collectors.toList());
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor) {
        return new ValidationResult(this, "Operation: '" + operationAdapterDescriptor.getDisplayName() + "' has one parameter that is not typed", operationAdapterDescriptor.getLocation());
    }
}

