/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.NativeOperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class DynamicOperationParametersMustNotBeTypedRule
extends DescriptorValidationRule {
    public DynamicOperationParametersMustNotBeTypedRule() {
        super("Dynamic parameters must not have type", "Any parameter declared in a operation with 'mule-TypeResolver' must not have 'type' or 'typeSchema' property.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
            if (operationAdapterDescriptor instanceof NativeOperationAdapterDescriptor) continue;
            for (AuxiliarParameterDescriptor auxiliarParameterDescriptor : operationAdapterDescriptor.getParameters()) {
                if (auxiliarParameterDescriptor.getMuleTypeResolver() == null || auxiliarParameterDescriptor.getDataType() == null && auxiliarParameterDescriptor.getInputType() == null) continue;
                validationResults.add(this.getValidationError(operationAdapterDescriptor, auxiliarParameterDescriptor));
            }
        }
        return validationResults;
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, AuxiliarParameterDescriptor auxiliarParameterDescriptor) {
        return new ValidationResult(this, "Operation: '" + operationAdapterDescriptor.getDisplayName() + "' has one parameter: '" + auxiliarParameterDescriptor.getName() + "' that has 'mule-TypeResolver' and is typed", auxiliarParameterDescriptor.getLocation());
    }
}

