/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarBodyBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;

public class OperationAdapterDifferentOutputMediaTypeRule
extends DescriptorValidationRule {
    public OperationAdapterDifferentOutputMediaTypeRule() {
        super("Operation response media type is different from the Api.", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List operationAdapterDescriptors = connectorDescriptor.getOperationAdapterDescriptors();
        for (OperationAdapterDescriptor operationAdapterDescriptor : operationAdapterDescriptors) {
            AuxiliarBodyBindingDescriptor bodyBinding;
            if (operationAdapterDescriptor.getResponseBindings() == null || operationAdapterDescriptor.getResponseBindings().getBodyBinding() == null || (bodyBinding = operationAdapterDescriptor.getResponseBindings().getBodyBinding()).getContentType() == null || this.hasSameMediaType(apiModel, operationAdapterDescriptor, bodyBinding)) continue;
            results.add(this.getValidationError(operationAdapterDescriptor, bodyBinding));
        }
        return results;
    }

    private boolean hasSameMediaType(APIModel apiModel, OperationAdapterDescriptor operationAdapterDescriptor, AuxiliarBodyBindingDescriptor bodyBinding) {
        APIOperationModel apiOperationModel = ValidationUtils.getApiOperation(apiModel, operationAdapterDescriptor);
        return apiOperationModel.getOutputMetadataModel().stream().anyMatch(m -> m.getMediaType().toString().equalsIgnoreCase(bodyBinding.getContentType()));
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, AuxiliarBodyBindingDescriptor bodyBinding) {
        String detail = "Operation with name " + operationAdapterDescriptor.getOperationId() + " declares a mediaType different from the one defined in the Api.";
        return new ValidationResult(this, detail, bodyBinding.getLocation());
    }
}

