/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarBodyBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class OperationAdapterOutputSchemaWithoutMediaTypeRule
extends DescriptorValidationRule {
    public OperationAdapterOutputSchemaWithoutMediaTypeRule() {
        super("Operation declares type schema but not media type.", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
            AuxiliarBodyBindingDescriptor bodyBinding;
            if (operationAdapterDescriptor.getResponseBindings() == null || operationAdapterDescriptor.getResponseBindings().getBodyBinding() == null || (bodyBinding = operationAdapterDescriptor.getResponseBindings().getBodyBinding()).getTypeSchema() == null || bodyBinding.getContentType() != null) continue;
            results.add(this.getValidationError(operationAdapterDescriptor, bodyBinding));
        }
        return results;
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, AuxiliarBodyBindingDescriptor bodyBinding) {
        String detail = "Operation with name " + operationAdapterDescriptor.getOperationId() + " declares a typeSchema in the response but not a mediaType.";
        return new ValidationResult(this, detail, bodyBinding.getLocation());
    }
}

