/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ExpressionHandlerUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.WeaveExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.mule.weave.v2.parser.phase.CompilationException;

public class PagedOperationsExpressionMustCompileRule
extends DescriptorValidationRule {
    private static final String[] IMPLICIT_INPUTS = new String[]{"payload", "attributes"};
    private static final String[] IMPLICIT_INPUTS_HYPERMEDIA = new String[]{"payload", "attributes", "link"};

    public PagedOperationsExpressionMustCompileRule() {
        super("Expression is invalid", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (PaginationDeclarationDescriptor paginationDeclaration : connectorDescriptor.getPaginations()) {
            if (paginationDeclaration == null) continue;
            if (paginationDeclaration.getNextTokenExpression() != null) {
                this.validateExpression(connectorDescriptor, paginationDeclaration, paginationDeclaration.getNextTokenExpression(), IMPLICIT_INPUTS, "nextToken", validationResults);
            }
            if (paginationDeclaration.getPagingResponseExpression() != null) {
                this.validateExpression(connectorDescriptor, paginationDeclaration, paginationDeclaration.getPagingResponseExpression(), IMPLICIT_INPUTS, "pagingResponse", validationResults);
            }
            if (paginationDeclaration.getPageCountExpression() != null) {
                this.validateExpression(connectorDescriptor, paginationDeclaration, paginationDeclaration.getPageCountExpression(), IMPLICIT_INPUTS, "pageCount", validationResults);
            }
            if (paginationDeclaration.getNextUrlExpression() == null) continue;
            this.validateExpression(connectorDescriptor, paginationDeclaration, paginationDeclaration.getNextUrlExpression(), IMPLICIT_INPUTS_HYPERMEDIA, "nextUrl", validationResults);
        }
        return validationResults;
    }

    private void validateExpression(ConnectorDescriptor connectorDescriptor, PaginationDeclarationDescriptor paginationDeclarationDescriptor, WeaveExpressionDescriptor expression, String[] implicitInputs, String expressionName, List<ValidationResult> validationResults) {
        try {
            ExpressionHandlerUtils.compileDataWeaveScript((String)expression.getExpression(), (String[])implicitInputs);
        }
        catch (CompilationException e) {
            validationResults.add(this.getValidationError(connectorDescriptor, paginationDeclarationDescriptor, expressionName, expression.getExpression(), e));
        }
    }

    private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor, PaginationDeclarationDescriptor paginationDeclarationDescriptor, String expressionName, String expression, CompilationException e) {
        String detail = String.format("'%s' expression '%s' in %s is not valid, error: \n%s", expressionName, expression, paginationDeclarationDescriptor.getName(), e.getMessage());
        return new ValidationResult(this, detail, paginationDeclarationDescriptor.getLocation());
    }
}

