/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationKind;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterRequestBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.RequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PagedParametersMustNotBeIgnoredRule
extends DescriptorValidationRule {
    public PagedParametersMustNotBeIgnoredRule() {
        super("for pageNumberPagination the queryParameter page_number can be ignored ", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        validationResults.addAll(this.validateOperations(connectorDescriptor));
        validationResults.addAll(this.validateOperationAdapters(connectorDescriptor));
        return validationResults;
    }

    private List<ValidationResult> validateOperations(ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (EndPointDescriptor endPointDescriptor : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operationDescriptor : endPointDescriptor.getOperations()) {
                RequestDescriptor requestDescriptor;
                PaginationDeclarationDescriptor paginationDeclaration = this.getPaginationDeclaration(operationDescriptor.getPagination(), connectorDescriptor);
                if (paginationDeclaration == null || !PaginationKind.PAGE_NUMBER.getName().equalsIgnoreCase(paginationDeclaration.getKind()) || (requestDescriptor = operationDescriptor.getExpects()) == null) continue;
                List parameters = requestDescriptor.getQueryParameter();
                for (ParameterDescriptor parameter : parameters) {
                    if (!parameter.getParamName().equals(paginationDeclaration.getPaginationParameterName()) || parameter.isIgnored() == null || !parameter.isIgnored().booleanValue()) continue;
                    validationResults.add(this.getValidationError(String.format("%s-%s", operationDescriptor.getMethod(), endPointDescriptor.getPath()), parameter.getLocation(), paginationDeclaration.getName(), parameter.getParamName(), paginationDeclaration.getKind(), false));
                }
            }
        }
        return validationResults;
    }

    private List<ValidationResult> validateOperationAdapters(ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
            AuxiliarParameterRequestBindingsDescriptor requestBindings;
            PaginationDeclarationDescriptor paginationDeclaration = this.getPaginationDeclaration(operationAdapterDescriptor.getPagination(), connectorDescriptor);
            if (paginationDeclaration == null || !PaginationKind.PAGE_NUMBER.getName().equalsIgnoreCase(paginationDeclaration.getKind()) || (requestBindings = operationAdapterDescriptor.getRequestBindings()) == null) continue;
            List queryParameters = requestBindings.getQueryParameters();
            for (AuxiliarParameterBindingDescriptor parameter : queryParameters) {
                if (!parameter.getName().equals(paginationDeclaration.getPaginationParameterName()) || parameter.getIgnored() == null || !parameter.getIgnored().booleanValue()) continue;
                validationResults.add(this.getValidationError(operationAdapterDescriptor.getOperationId(), parameter.getLocation(), paginationDeclaration.getName(), parameter.getName(), paginationDeclaration.getKind(), true));
            }
        }
        return validationResults;
    }

    private PaginationDeclarationDescriptor getPaginationDeclaration(String paginationName, ConnectorDescriptor connectorDescriptor) {
        PaginationDeclarationDescriptor paginationDescriptor = null;
        if (StringUtils.isNotBlank((CharSequence)paginationName)) {
            paginationDescriptor = connectorDescriptor.getPaginations().stream().filter(x -> x.getName().equalsIgnoreCase(paginationName)).findFirst().orElse(null);
        }
        return paginationDescriptor;
    }

    private ValidationResult getValidationError(String operationIdentifier, DescriptorElementLocation paramenterLocation, String namePagination, String parameterName, String typePagination, boolean isOperationAdapter) {
        String detail = (isOperationAdapter ? "Custom Operation : " : "Endpoint operation : ") + operationIdentifier + " use Pagination " + namePagination + " with a parameter with name " + parameterName + " which was ignored and is required for type pagination " + typePagination + ".";
        return new ValidationResult(this, detail, paramenterLocation);
    }
}

