/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ApiValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.CompleteConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.StepConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.api.AtLeastOneSupportedSecuritySchemeRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.api.NotSupportedSecuritySchemeRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.ConnectorMustHaveCompleteGavRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.OperationIdentifierScriptMustNotRepeatRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.OperationInternalNameMustNotRepeatRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.OperationNameMustBeFriendlyRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete.NoDefaultInputMediaTypeDefinedRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete.NoDefaultOutputMediaTypeDefinedRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete.NoInputMediaTypeDefinedRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete.NoOutputMediaTypeDefinedRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete.OperationMustDeclareResponseBodyRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete.PagedOperationsOperationMustDeclareResponseBodyRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.step.TriggerMandatoryFieldsRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.BaseJavaPackageMustBeValidRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.ConnectorNameMustBeFriendlyRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.DescriptorAdditionalParameterMandatoryFieldsRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.DescriptorAdditionalParameterMustNotBePresentInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.DescriptorInputMediaTypeMustBePresentInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.DescriptorOperationMustExistInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.DescriptorOtputMediaTypeMustBePresentInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.DescriptorParameterMustBePresentInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.DescriptorPathMustExistInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.DescriptorRedundantOutputDefinitionRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.ExtensionXmlMustBeValidRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.GavArtifactIdMustBeValidRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.GavGroupIdMustBeValidRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.GavVersionMustBeValidRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.OperationAdapterBindingParameterWithValueMustNotBeIgnoredRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.OperationAdapterUriParameterMustNotBeIgnoredRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.OperationDisplayNameScriptMustCompileRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.OperationIdentifierScriptMustCompileRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.PagedOperationsExpressionMustCompileRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.PagedOperationsParameterMustExistRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.SampleDataReferenceArgumentsExistsRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.SampleDataSameOperationMustBeGETRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.TriggerBindingParameterMustExistInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.TriggerPathAndMethodMustExistInApiRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.TriggerUriParamsMustBeCompleteRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.ValueProviderBodyLevelReferenceArgumentsHaveValidFormatRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.ValueProviderReferenceArgumentsExistsRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.ValueProviderReferenceArgumentsHaveValidFormatRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.ValueProviderReferenceArgumentsOperationParameterExistsRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationEngine.class);
    private final List<ValidationResult> validationResults = new ArrayList<ValidationResult>();
    private final List<ValidationRule> rules;
    public static final List<ValidationRule> ALL_RULES = new ArrayList<ValidationRule>();

    public ValidationEngine() {
        this.rules = ALL_RULES;
    }

    public ValidationEngine(List<ValidationRule> rules) {
        this.rules = rules;
    }

    public void validateApi(APIModel apiModel) {
        List apiResults = this.rules.stream().filter(x -> x instanceof ApiValidationRule).flatMap(x -> ((ApiValidationRule)x).validate(apiModel).stream()).collect(Collectors.toList());
        this.validationResults.addAll(apiResults);
    }

    public void validateDescriptor(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        List descriptorResults = this.rules.stream().filter(x -> x instanceof DescriptorValidationRule).flatMap(x -> ((DescriptorValidationRule)x).validate(apiModel, connectorDescriptor).stream()).collect(Collectors.toList());
        this.validationResults.addAll(descriptorResults);
    }

    public void validateConnectorModelBuilderStep(ConnectorModelBuilder connectorModelBuilder) {
        List connectorResults = this.rules.stream().filter(x -> x instanceof StepConnectorModelBuilderValidationRule).flatMap(x -> ((StepConnectorModelBuilderValidationRule)x).validate(connectorModelBuilder).stream()).collect(Collectors.toList());
        this.validationResults.addAll(connectorResults);
    }

    public void validateConnectorModelBuilder(ConnectorModelBuilder connectorModelBuilder) {
        List connectorResults = this.rules.stream().filter(x -> x instanceof CompleteConnectorModelBuilderValidationRule).flatMap(x -> ((CompleteConnectorModelBuilderValidationRule)x).validate(connectorModelBuilder).stream()).collect(Collectors.toList());
        this.validationResults.addAll(connectorResults);
    }

    public void validateConnectorModel(ConnectorModel connectorModel) {
        List connectorResults = this.rules.stream().filter(x -> x instanceof ConnectorModelValidationRule).flatMap(x -> ((ConnectorModelValidationRule)x).validate(connectorModel).stream()).collect(Collectors.toList());
        this.validationResults.addAll(connectorResults);
    }

    public boolean isSuccess() {
        return this.validationResults.stream().noneMatch(x -> x.getLevel().equals((Object)ValidationRule.Level.ERROR));
    }

    public void logResults() {
        this.validationResults.stream().filter(x -> x.getLevel().equals((Object)ValidationRule.Level.ERROR)).forEach(x -> LOGGER.error(x + System.lineSeparator()));
        this.validationResults.stream().filter(x -> x.getLevel().equals((Object)ValidationRule.Level.WARN)).forEach(x -> LOGGER.warn(x + System.lineSeparator()));
        this.validationResults.stream().filter(x -> x.getLevel().equals((Object)ValidationRule.Level.INFO)).forEach(x -> LOGGER.warn(x + System.lineSeparator()));
    }

    public List<ValidationResult> getResults() {
        return this.validationResults;
    }

    static {
        ALL_RULES.add(new DescriptorPathMustExistInApiRule());
        ALL_RULES.add(new DescriptorOperationMustExistInApiRule());
        ALL_RULES.add(new OperationMustDeclareResponseBodyRule());
        ALL_RULES.add(new AtLeastOneSupportedSecuritySchemeRule());
        ALL_RULES.add(new ExtensionXmlMustBeValidRule());
        ALL_RULES.add(new BaseJavaPackageMustBeValidRule());
        ALL_RULES.add(new GavGroupIdMustBeValidRule());
        ALL_RULES.add(new GavArtifactIdMustBeValidRule());
        ALL_RULES.add(new GavVersionMustBeValidRule());
        ALL_RULES.add(new NotSupportedSecuritySchemeRule());
        ALL_RULES.add(new ConnectorNameMustBeFriendlyRule());
        ALL_RULES.add(new OperationNameMustBeFriendlyRule());
        ALL_RULES.add(new OperationDisplayNameScriptMustCompileRule());
        ALL_RULES.add(new OperationIdentifierScriptMustCompileRule());
        ALL_RULES.add(new OperationIdentifierScriptMustNotRepeatRule());
        ALL_RULES.add(new OperationInternalNameMustNotRepeatRule());
        ALL_RULES.add(new NoDefaultInputMediaTypeDefinedRule());
        ALL_RULES.add(new NoDefaultOutputMediaTypeDefinedRule());
        ALL_RULES.add(new DescriptorParameterMustBePresentInApiRule());
        ALL_RULES.add(new NoInputMediaTypeDefinedRule());
        ALL_RULES.add(new DescriptorInputMediaTypeMustBePresentInApiRule());
        ALL_RULES.add(new NoOutputMediaTypeDefinedRule());
        ALL_RULES.add(new DescriptorOtputMediaTypeMustBePresentInApiRule());
        ALL_RULES.add(new DescriptorRedundantOutputDefinitionRule());
        ALL_RULES.add(new PagedOperationsOperationMustDeclareResponseBodyRule());
        ALL_RULES.add(new TriggerPathAndMethodMustExistInApiRule());
        ALL_RULES.add(new TriggerBindingParameterMustExistInApiRule());
        ALL_RULES.add(new TriggerUriParamsMustBeCompleteRule());
        ALL_RULES.add(new ValueProviderReferenceArgumentsExistsRule());
        ALL_RULES.add(new ValueProviderReferenceArgumentsHaveValidFormatRule());
        ALL_RULES.add(new SampleDataSameOperationMustBeGETRule());
        ALL_RULES.add(new SampleDataReferenceArgumentsExistsRule());
        ALL_RULES.add(new PagedOperationsParameterMustExistRule());
        ALL_RULES.add(new PagedOperationsExpressionMustCompileRule());
        ALL_RULES.add(new DescriptorAdditionalParameterMandatoryFieldsRule());
        ALL_RULES.add(new DescriptorAdditionalParameterMustNotBePresentInApiRule());
        ALL_RULES.add(new ConnectorMustHaveCompleteGavRule());
        ALL_RULES.add(new ValueProviderReferenceArgumentsOperationParameterExistsRule());
        ALL_RULES.add(new TriggerMandatoryFieldsRule());
        ALL_RULES.add(new ValueProviderBodyLevelReferenceArgumentsHaveValidFormatRule());
        ALL_RULES.add(new OperationAdapterUriParameterMustNotBeIgnoredRule());
        ALL_RULES.add(new OperationAdapterBindingParameterWithValueMustNotBeIgnoredRule());
    }
}

