/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.removeJavaPackageUnwantedCharacters;
import static org.apache.commons.lang3.StringUtils.isBlank;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class BaseJavaPackageMustBeValidRule extends DescriptorValidationRule {

  // R006
  public BaseJavaPackageMustBeValidRule() {
    super("Descriptor baseJavaPackage must ve a valid java package name",
          "When present in the connector descriptor, baseJavaPackage property must be a valid java package.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {

    List<ValidationResult> validationResults = new ArrayList<>();

    String javaPackage = connectorDescriptor.getBaseJavaPackage();

    if (isBlank(javaPackage)) {
      return validationResults;
    }

    String validJavaPackage = removeJavaPackageUnwantedCharacters(javaPackage);

    if (!javaPackage.equalsIgnoreCase(validJavaPackage)) {
      validationResults.add(getValidationError(connectorDescriptor));
    }

    return validationResults;
  }

  private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
    return new ValidationResult(this, "Descriptor baseJavaPackage", connectorDescriptor.getLocation());
  }
}
