/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.connectormodelbuilder;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import static org.apache.commons.lang3.StringUtils.EMPTY;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.List;
import java.util.stream.Collectors;

public class BaseOperationMustExistRule extends DescriptorConnectorModelBuilderValidationRule {

  public BaseOperationMustExistRule() {
    super("Base Operation must exist", EMPTY, ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor,
                                         ConnectorModelBuilder connectorModelBuilder) {

    return connectorDescriptor.getOperationAdapterDescriptors().stream()
        .filter(operationAdapterDescriptor -> !baseOperationExist(operationAdapterDescriptor, connectorModelBuilder))
        .map(this::getValidationError)
        .collect(Collectors.toList());
  }

  private boolean baseOperationExist(OperationAdapterDescriptor operationAdapterDescriptor,
                                     ConnectorModelBuilder connectorModelBuilder) {
    return connectorModelBuilder.getOperationBuildersByOperationId(operationAdapterDescriptor.getBaseOperationId()).isPresent();
  }

  private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor) {
    String detail =
        "Operation with name: '"
            + operationAdapterDescriptor.getOperationId()
            + "' defines a base operation: '"
            + operationAdapterDescriptor.getBaseOperationId()
            + "' that does not exist";

    return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
  }
}
