/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ParametersIdentifiersMustNotRepeatRule
extends ConnectorModelValidationRule {
    public ParametersIdentifiersMustNotRepeatRule() {
        super("Parameter's identifier must not be repeated within the same operation.", "The identifier of some parameters, are colliding.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        List<ValidationResult> validationResults = connectorModel.getOperations().stream().map(this::validateParametersIdentifiers).flatMap(Collection::stream).collect(Collectors.toList());
        return validationResults;
    }

    private List<ValidationResult> validateParametersIdentifiers(ConnectorOperation operation) {
        HashMap parametersIdentifiers = new HashMap();
        Consumer<Parameter> collisionSearcher = parameter -> {
            if (!parametersIdentifiers.containsKey(parameter.getParameterIdentifier())) {
                parametersIdentifiers.put(parameter.getParameterIdentifier(), new ArrayList());
            }
            ((List)parametersIdentifiers.get(parameter.getParameterIdentifier())).add(parameter);
        };
        operation.getUriParameters().forEach(collisionSearcher);
        operation.getHeaders().forEach(collisionSearcher);
        operation.getQueryParameters().forEach(collisionSearcher);
        List<ValidationResult> validationResults = parametersIdentifiers.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> this.getValidationError((String)entry.getKey(), operation, (List)entry.getValue())).collect(Collectors.toList());
        return validationResults;
    }

    private ValidationResult getValidationError(String parameterIdentifier, ConnectorOperation op, List<Parameter> parameters) {
        ArrayList<String> uriParams = new ArrayList<String>();
        ArrayList<String> headerParams = new ArrayList<String>();
        ArrayList<String> queryParams = new ArrayList<String>();
        parameters.forEach(p -> {
            switch (p.getParameterType()) {
                case URI: {
                    uriParams.add(p.getExternalName());
                    break;
                }
                case QUERY: {
                    queryParams.add(p.getExternalName());
                    break;
                }
                case HEADER: {
                    headerParams.add(p.getExternalName());
                    break;
                }
            }
        });
        String uriParamsBlock = this.getListWithNamespaceOrEmpty(uriParams, "URI params");
        String headersParamsBlock = this.getListWithNamespaceOrEmpty(headerParams, "headers");
        String queryParamsBlock = this.getListWithNamespaceOrEmpty(queryParams, "query params");
        String detail = String.format("The operation [%s:%s] has several parameters with the same 'parameterIdentifier:%s'. Please check the following: %s%s%s", op.getHttpMethod(), op.getPath(), parameterIdentifier, uriParamsBlock, headersParamsBlock, queryParamsBlock);
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }

    private String getListWithNamespaceOrEmpty(List<String> uriParams, String typeParams) {
        return uriParams.isEmpty() ? "" : String.format("\n\t" + typeParams + ": %s", String.join((CharSequence)", ", uriParams));
    }
}

