/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterRequestBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class OperationAdapterBindingParameterWithValueMustNotBeIgnoredRule
extends DescriptorValidationRule {
    public OperationAdapterBindingParameterWithValueMustNotBeIgnoredRule() {
        super("Parameter bindings with value cannot be ignored.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List operationAdapterDescriptors = connectorDescriptor.getOperationAdapterDescriptors();
        if (!operationAdapterDescriptors.isEmpty()) {
            for (OperationAdapterDescriptor operationAdapterDescriptor : operationAdapterDescriptors) {
                AuxiliarParameterRequestBindingsDescriptor requestBindings = operationAdapterDescriptor.getRequestBindings();
                if (requestBindings == null) continue;
                this.analyzeParameters(results, operationAdapterDescriptor, requestBindings.getHeaders(), ParameterType.HEADER);
                this.analyzeParameters(results, operationAdapterDescriptor, requestBindings.getQueryParameters(), ParameterType.QUERY);
                this.analyzeParameters(results, operationAdapterDescriptor, requestBindings.getUriParameters(), ParameterType.URI);
            }
        }
        return results;
    }

    private void analyzeParameters(List<ValidationResult> results, OperationAdapterDescriptor operationAdapterDescriptor, List<AuxiliarParameterBindingDescriptor> bindings, ParameterType bindingParameterType) {
        for (AuxiliarParameterBindingDescriptor binding : bindings) {
            if (binding.getIgnored() == null || !binding.getIgnored().booleanValue() || !StringUtils.isNotEmpty((CharSequence)binding.getValue())) continue;
            results.add(this.getValidationError(operationAdapterDescriptor, binding, bindingParameterType));
        }
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, AuxiliarParameterBindingDescriptor binding, ParameterType parameterType) {
        String detail = parameterType.getName() + " parameter binding '" + binding.getName() + "' defined in Operation with name: " + operationAdapterDescriptor.getOperationId() + " is ignored and has a value defined.";
        return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
    }
}

