/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;

public class TriggerUriParamsMustBeCompleteRule
extends DescriptorValidationRule {
    public TriggerUriParamsMustBeCompleteRule() {
        super("All URI parameters must be have a binding in the Trigger Descriptor.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List triggerDescriptors = connectorDescriptor.getTriggers();
        if (!triggerDescriptors.isEmpty()) {
            for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
                List uriParamsModel;
                APIOperationModel operationModel = ValidationUtils.getApiOperation(apiModel, triggerDescriptor);
                if (operationModel == null || (uriParamsModel = operationModel.getUriParamsModel()).isEmpty()) continue;
                if (triggerDescriptor.getParameterBindings() == null || triggerDescriptor.getParameterBindings().getUriParameters() == null) {
                    results.add(this.getValidationError(triggerDescriptor));
                    continue;
                }
                if (uriParamsModel.size() <= triggerDescriptor.getParameterBindings().getUriParameters().size()) continue;
                results.add(this.getValidationError(triggerDescriptor));
            }
        }
        return results;
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor) {
        String detail = "Trigger with PATH: " + triggerDescriptor.getPath() + " and METHOD: " + triggerDescriptor.getMethod().getName().toUpperCase() + " is missing a binding for one of its URI parameters";
        return new ValidationResult(this, detail, triggerDescriptor.getLocation());
    }
}

