/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.connectormodelbuilder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.List;
import java.util.stream.Collectors;

public class BaseOperationMustExistRule
extends DescriptorConnectorModelBuilderValidationRule {
    public BaseOperationMustExistRule() {
        super("Base Operation must exist", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        return connectorDescriptor.getOperationAdapterDescriptors().stream().filter(operationAdapterDescriptor -> !this.baseOperationExist((OperationAdapterDescriptor)operationAdapterDescriptor, connectorModelBuilder)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean baseOperationExist(OperationAdapterDescriptor operationAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        return connectorModelBuilder.getOperationBuildersByOperationId(operationAdapterDescriptor.getBaseOperationId()).isPresent();
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor) {
        String detail = "Operation with name: '" + operationAdapterDescriptor.getOperationId() + "' defines a base operation: '" + operationAdapterDescriptor.getBaseOperationId() + "' that does not exist";
        return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
    }
}

