/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.WARN;
import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil.isFriendlyName;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class ConnectorNameMustBeFriendlyRule extends DescriptorValidationRule {

  // R011
  public ConnectorNameMustBeFriendlyRule() {
    super("connectorName property seems not to be a friendly name",
          "The connectorName declared in the descriptor should be a human readable name separated with spaces.",
          WARN);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {

    List<ValidationResult> validationResults = new ArrayList<>();

    String connectorName = connectorDescriptor.getConnectorName();

    if (isNotBlank(connectorName) && !isFriendlyName(connectorName)) {
      validationResults.add(getValidationError(connectorDescriptor));
    }

    return validationResults;
  }

  private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
    return new ValidationResult(this,
                                "connectorName : " + connectorDescriptor.getConnectorName(),
                                connectorDescriptor.getLocation());
  }
}
