/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import static org.apache.commons.lang3.StringUtils.EMPTY;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

//TODO RSDK-608: adapt the validator for parameters that are required, not only URI ones
public class OperationAdapterUriParameterMustNotBeIgnoredRule extends DescriptorValidationRule {

  public OperationAdapterUriParameterMustNotBeIgnoredRule() {
    super("URI Parameter bindings must not be ignored.", EMPTY, ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    final List<ValidationResult> results = new ArrayList<>();

    List<OperationAdapterDescriptor> operationAdapterDescriptors = connectorDescriptor.getOperationAdapterDescriptors();
    if (!operationAdapterDescriptors.isEmpty()) {
      for (OperationAdapterDescriptor operationAdapterDescriptor : operationAdapterDescriptors) {
        if (operationAdapterDescriptor.getRequestBindings() != null) {
          analyzeUriParametersBinding(results, operationAdapterDescriptor,
                                      operationAdapterDescriptor.getRequestBindings().getUriParameters());
        }
      }
    }

    return results;
  }

  private void analyzeUriParametersBinding(List<ValidationResult> results, OperationAdapterDescriptor operationAdapterDescriptor,
                                           List<AuxiliarParameterBindingDescriptor> parameterBindingDescriptors) {

    for (AuxiliarParameterBindingDescriptor binding : parameterBindingDescriptors) {
      if (binding.getIgnored() != null && binding.getIgnored()) {
        results.add(getValidationError(operationAdapterDescriptor, binding));
      }
    }

  }

  private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor,
                                              AuxiliarParameterBindingDescriptor binding) {
    String detail = "Uri parameter binding '"
        + binding.getName()
        + "' defined in Operation with name: "
        + operationAdapterDescriptor.getOperationId()
        + " cannot be ignored as it's required.";

    return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
  }

}
