/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;

import org.mule.weave.v2.parser.phase.CompilationException;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperationIdentifierScriptMustCompileRule extends DescriptorValidationRule {

  public OperationIdentifierScriptMustCompileRule() {
    super("Operation identifier expression is incorrect",
          String.format("The 'operationIdentifier' must be revisited (available bindings are '%s')",
                        Arrays.toString(OperationIdentifierExpressionHandler.IMPLICIT_INPUTS)),
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    List<ValidationResult> result = new ArrayList<>();
    ExpressionDescriptor operationIdentifier = connectorDescriptor.getOperationIdentifier();
    if (operationIdentifier != null) {
      String expression = operationIdentifier.getExpression();
      try {
        new OperationIdentifierExpressionHandler(expression);
      } catch (CompilationException e) {
        result.add(getValidationError(connectorDescriptor, e));
      }
    }

    return result;
  }

  private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor, CompilationException e) {
    String detail = "Expression in 'operationIdentifier' is not valid, error: \n" + e.getMessage();

    return new ValidationResult(this, detail, connectorDescriptor.getOperationIdentifier().getLocation());
  }

}
