/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.api;

import com.mulesoft.connectivity.rest.sdk.api.DescriptorMode;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorPackage;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.APISpecDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.APIUrlDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.BaseUriDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.RequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.writer.DescriptorWriter;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFAPIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DescriptorScaffolder {
    private static final Logger LOGGER = LogManager.getLogger(DescriptorScaffolder.class);
    private static final String DEFAULT_MVN_GROUP_ID = "com.mulesoft.connectors";
    private static final String DEFAULT_MVN_VERSION = "1.0.0-SNAPSHOT";
    private static final String DESCRIPTOR_FILE_NAME_DEFAULT = "descriptor.yaml";
    private static final String DESCRIPTOR_FILE_NAME_TEMPLATE = "descriptor-%s.yaml";

    private DescriptorScaffolder() {
    }

    public static void scaffoldDescriptor(File spec, Path outputDir, DescriptorMode descriptorMode, boolean skipValidation) throws ModelGenerationException, IOException {
        ConnectorDescriptor connectorDescriptor = DescriptorScaffolder.scaffoldDescriptorModel(spec, descriptorMode, skipValidation);
        DescriptorScaffolder.writeToYaml(connectorDescriptor, outputDir);
    }

    public static ConnectorDescriptor scaffoldDescriptorModel(File spec, DescriptorMode descriptorMode, boolean skipValidation) throws ModelGenerationException {
        AMFAPIModel apiModel = new AMFAPIModel(spec, spec.getParent(), skipValidation);
        return DescriptorScaffolder.generateConnectorDescriptor(spec.toPath(), (APIModel)apiModel, descriptorMode);
    }

    public static void writeToYaml(ConnectorDescriptor connectorDescriptor, Path outputDir) throws IOException {
        String yaml = new DescriptorWriter().write(connectorDescriptor);
        FileUtils.writeStringToFile((File)DescriptorScaffolder.getOutputFile(outputDir), (String)yaml, (Charset)StandardCharsets.UTF_8);
    }

    private static File getOutputFile(Path outputDir) {
        File outputFileCandidate = outputDir.resolve(DESCRIPTOR_FILE_NAME_DEFAULT).toFile();
        if (outputFileCandidate.exists()) {
            LOGGER.warn(String.format("File '%s' already exists.", outputFileCandidate.toString()));
        }
        int i = 1;
        while (outputFileCandidate.exists()) {
            outputFileCandidate = outputDir.resolve(String.format(DESCRIPTOR_FILE_NAME_TEMPLATE, i++)).toFile();
        }
        LOGGER.info(String.format("Writing descriptor to '%s'.", outputFileCandidate.toString()));
        return outputFileCandidate;
    }

    private static ConnectorDescriptor generateConnectorDescriptor(Path specPath, APIModel apiModel, DescriptorMode descriptorMode) {
        return new ConnectorDescriptor(descriptorMode.isGenerateApiSpec() ? DescriptorScaffolder.generateAPISpec(specPath) : null, descriptorMode.isGenerateApiName() ? DescriptorScaffolder.generateApiName(apiModel) : null, descriptorMode.isGenerateDescription() ? apiModel.getDescription() : null, descriptorMode.isGenerateConnectorGav() ? DescriptorScaffolder.generateConnectorGav(apiModel) : null, descriptorMode.isGenerateBaseUri() ? DescriptorScaffolder.generateBaseUri(apiModel) : null, descriptorMode.isGenerateEndpoints() ? DescriptorScaffolder.generateEndpoints(apiModel) : Collections.EMPTY_LIST, descriptorMode.isGeneratePaginations() ? DescriptorScaffolder.generatePaginations() : Collections.EMPTY_LIST, descriptorMode.isGenerateSecurity() ? DescriptorScaffolder.generateSecurity() : Collections.EMPTY_LIST, ConnectorCategory.SELECT.toString(), descriptorMode.isGenerateDefaultPackage() ? DescriptorScaffolder.generateDefaultPackage(apiModel) : null, descriptorMode.isGenerateExtensionXml() ? XmlUtils.getXmlName((String)DescriptorScaffolder.generateApiName(apiModel)) : null, null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, DescriptorElementLocation.builder().empty(), null);
    }

    private static String generateDefaultPackage(APIModel apiModel) {
        return ConnectorPackage.buildBasePackage((String)DescriptorScaffolder.generateApiName(apiModel));
    }

    private static String generateApiName(APIModel apiModel) {
        String notApiName = apiModel.getApiName().replaceAll("[\\s]+(?i)api[\\s]+", "").replaceAll("^(?i)api[\\s]+", "").replaceAll("[\\s]+(?i)api$", "");
        return NamingUtil.makeNameFriendly((String)notApiName);
    }

    private static List<SecuritySchemeDescriptor> generateSecurity() {
        return Collections.emptyList();
    }

    private static List<EndPointDescriptor> generateEndpoints(APIModel apiModel) {
        return apiModel.getOperationsModel().stream().map(APIOperationModel::getPath).distinct().map(x -> DescriptorScaffolder.generateEndpoint(x, apiModel)).collect(Collectors.toList());
    }

    private static EndPointDescriptor generateEndpoint(String path, APIModel apiModel) {
        return new EndPointDescriptor(path, DescriptorScaffolder.generateOperations(path, apiModel), Boolean.valueOf(false), null, DescriptorElementLocation.builder().empty());
    }

    private static List<OperationDescriptor> generateOperations(String path, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path)).map(DescriptorScaffolder::generateOperation).collect(Collectors.toList());
    }

    private static OperationDescriptor generateOperation(APIOperationModel operationModel) {
        return new OperationDescriptor(operationModel.getHttpMethod().toLowerCase(), DescriptorScaffolder.generateOperationDisplayName(operationModel), operationModel.getDescription(), DescriptorScaffolder.generateDefaultInputMediaType(operationModel), DescriptorScaffolder.generateDefaultOutputMediaType(operationModel), DescriptorScaffolder.generateRequest(operationModel), Boolean.valueOf(false), null, null, DescriptorScaffolder.isBodylessResponse(operationModel), DescriptorScaffolder.isBodylessResponse(operationModel), null, null, null, DescriptorElementLocation.builder().empty(), null, null);
    }

    private static String generateOperationDisplayName(APIOperationModel operationModel) {
        if (StringUtils.isEmpty((String)operationModel.getName())) {
            return null;
        }
        return NamingUtil.isFriendlyName((String)operationModel.getName()) ? operationModel.getName() : NamingUtil.makeNameFriendly((String)operationModel.getName());
    }

    private static Boolean isBodylessResponse(APIOperationModel operationModel) {
        boolean methodRequiresBody;
        boolean bl = methodRequiresBody = operationModel.getHttpMethod().equalsIgnoreCase("GET") || operationModel.getHttpMethod().equalsIgnoreCase("POST") || operationModel.getHttpMethod().equalsIgnoreCase("PATCH") || operationModel.getHttpMethod().equalsIgnoreCase("OPTIONS");
        if (methodRequiresBody && operationModel.getOutputMetadataModel().isEmpty()) {
            return false;
        }
        boolean emptyBody = operationModel.getOutputMetadataModel().stream().allMatch(x -> x.getApiType() == null || x.getApiType().equals((Object)APIType.EMPTY));
        if (methodRequiresBody && emptyBody) {
            return false;
        }
        return null;
    }

    private static String generateDefaultInputMediaType(APIOperationModel operationModel) {
        if (!operationModel.getInputMetadataModel().isEmpty() && ((APITypeModel)operationModel.getInputMetadataModel().get(0)).getMediaType() != null) {
            return ((APITypeModel)operationModel.getInputMetadataModel().get(0)).getMediaType().toString();
        }
        return null;
    }

    private static String generateDefaultOutputMediaType(APIOperationModel operationModel) {
        if (!operationModel.getOutputMetadataModel().isEmpty() && ((APITypeModel)operationModel.getOutputMetadataModel().get(0)).getMediaType() != null) {
            return ((APITypeModel)operationModel.getOutputMetadataModel().get(0)).getMediaType().toString();
        }
        return null;
    }

    private static RequestDescriptor generateRequest(APIOperationModel operationModel) {
        return new RequestDescriptor(DescriptorScaffolder.generateParameters(operationModel.getHeadersModel()), DescriptorScaffolder.generateParameters(operationModel.getQueryParamsModel()), DescriptorScaffolder.generateParameters(operationModel.getUriParamsModel()), new ArrayList(), null, DescriptorElementLocation.builder().empty());
    }

    private static List<ParameterDescriptor> generateParameters(List<APIParameterModel> parametersModel) {
        return parametersModel.stream().map(DescriptorScaffolder::generateParameter).collect(Collectors.toList());
    }

    private static ParameterDescriptor generateParameter(APIParameterModel parameterModel) {
        return new ParameterDescriptor(DescriptorScaffolder.generateParameterDisplayName(parameterModel), parameterModel.getExternalName(), parameterModel.getDescription(), false, null, DescriptorElementLocation.builder().empty());
    }

    private static String generateParameterDisplayName(APIParameterModel parameterModel) {
        String displayName;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)parameterModel.getDisplayName())) {
            displayName = parameterModel.getDisplayName();
        } else {
            displayName = parameterModel.getExternalName();
            if (!NamingUtil.isFriendlyName((String)displayName)) {
                displayName = NamingUtil.makeNameFriendly((String)displayName);
            }
        }
        return displayName;
    }

    private static List<PaginationDeclarationDescriptor> generatePaginations() {
        return Collections.emptyList();
    }

    private static BaseUriDescriptor generateBaseUri(APIModel apiModel) {
        return new BaseUriDescriptor(apiModel.getBaseUri(), "parameter", Collections.emptyList(), DescriptorElementLocation.builder().empty());
    }

    private static MavenGavDescriptor generateConnectorGav(APIModel apiModel) {
        return new MavenGavDescriptor(DEFAULT_MVN_GROUP_ID, XmlUtils.getXmlName((String)apiModel.getApiName()), DEFAULT_MVN_VERSION, DescriptorElementLocation.builder().empty());
    }

    private static APISpecDescriptor generateAPISpec(Path specPath) {
        return new APIUrlDescriptor(specPath.toString(), null);
    }
}

