/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.api;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ApiValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class AccessTokenUrlAndAuthorizationUrlMustNotBeNullRule
extends ApiValidationRule {
    public AccessTokenUrlAndAuthorizationUrlMustNotBeNullRule() {
        super("In OAS 2.0 the AccessTokenUrl and AuthorizationUrl parameters should have a value in Oauth 2.0 authentication", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        List listSecuritySchemeModels = apiModel.getOperationsModel().stream().map(APIOperationModel::getSecuritySchemesModel).flatMap(Collection::stream).filter(ValidationUtils.distinctByKey(APISecuritySchemeModel::getName)).collect(Collectors.toList());
        for (APISecuritySchemeModel apiSecuritySchemeModel : listSecuritySchemeModels) {
            APISecuritySchemeType type = apiSecuritySchemeModel.getSecuritySchemeType();
            if (type != APISecuritySchemeType.OAUTH2_CLIENT_CREDENTIALS && type != APISecuritySchemeType.OAUTH2_AUTHORIZATION_CODE || apiSecuritySchemeModel.getAuthorizationUri() != null && apiSecuritySchemeModel.getAccessTokenUri() != null) continue;
            validationResults.add(this.getValidationError(apiSecuritySchemeModel.getName(), apiSecuritySchemeModel.getAuthorizationUri(), apiSecuritySchemeModel.getAccessTokenUri()));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(String name, String authorizationUrl, String accessTokenUrl) {
        String detail = "";
        if (authorizationUrl == null && accessTokenUrl == null) {
            detail = "Parameter TokenUrl and AuthorizationUrl were not declared.";
        }
        if (authorizationUrl == null && accessTokenUrl != null) {
            detail = "Parameter AuthorizationUrl was not declared.";
        }
        if (authorizationUrl != null && accessTokenUrl == null) {
            detail = "Parameter TokenUrl was not declared.";
        }
        return new ValidationResult(this, "In the APISpec, security scheme with name " + name + " " + detail, DescriptorElementLocation.builder().empty());
    }
}

