/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ConnectorMustHaveRootBaseUriRule
extends ConnectorModelValidationRule {
    public ConnectorMustHaveRootBaseUriRule() {
        super("The connector must declare base URI.", "Use the 'baseUri.value' property of the connector descriptor to set it up since it couldn't be inferred from the api spec.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        String baseUri = connectorModel.getBaseUri().getUri();
        if (StringUtils.isBlank((CharSequence)baseUri)) {
            Set<String> baseUris = connectorModel.getOperations().stream().map(ConnectorOperation::getBaseUris).flatMap(Collection::stream).collect(Collectors.toSet());
            return Collections.singletonList(this.getValidationError(baseUris));
        }
        return Collections.emptyList();
    }

    private ValidationResult getValidationError(Set<String> baseUris) {
        String detail = baseUris.isEmpty() ? "No operation to infer to base Uri." : "There are more than one base Uri in the descriptor operations, please define only one.";
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }
}

