/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.util;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.FieldDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.RequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ValidationUtils {
    public static EndPointDescriptor getEndpointDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).findFirst().orElse(null);
    }

    public static OperationDescriptor getOperationDescriptor(EndPointDescriptor endPointDescriptor, APIOperationModel apiOperationModel) {
        return endPointDescriptor.getOperations().stream().filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod())).findFirst().orElse(null);
    }

    public static DescriptorElement getClosestDescriptorElement(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        EndPointDescriptor endpointDescriptor = ValidationUtils.getEndpointDescriptor(connectorDescriptor, apiOperationModel);
        if (endpointDescriptor == null) {
            return connectorDescriptor;
        }
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(endpointDescriptor, apiOperationModel);
        if (operationDescriptor == null) {
            return endpointDescriptor;
        }
        return operationDescriptor;
    }

    public static EndPointDescriptor getEndpointDescriptor(ConnectorDescriptor connectorDescriptor, ConnectorOperation connectorOperation) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(connectorOperation.getPath())).findFirst().orElse(null);
    }

    public static OperationDescriptor getOperationDescriptor(EndPointDescriptor endPointDescriptor, ConnectorOperation connectorOperation) {
        return endPointDescriptor.getOperations().stream().filter(x -> x.getMethod().equalsIgnoreCase(connectorOperation.getHttpMethod().name())).findFirst().orElse(null);
    }

    public static DescriptorElement getClosestDescriptorElement(ConnectorDescriptor connectorDescriptor, ConnectorOperation connectorOperation) {
        EndPointDescriptor endpointDescriptor = ValidationUtils.getEndpointDescriptor(connectorDescriptor, connectorOperation);
        if (endpointDescriptor == null) {
            return connectorDescriptor;
        }
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(endpointDescriptor, connectorOperation);
        if (operationDescriptor == null) {
            return endpointDescriptor;
        }
        return operationDescriptor;
    }

    public static APIOperationModel getApiOperationModel(APIModel apiModel, ConnectorOperation connectorOperation) {
        return apiModel.getOperationsModel().stream().filter(x -> connectorOperation.getPath().equalsIgnoreCase(x.getPath())).filter(x -> connectorOperation.getHttpMethod().name().equalsIgnoreCase(x.getHttpMethod())).findFirst().orElse(null);
    }

    public static boolean apiOperationIsPresentInConnectorModel(APIOperationModel apiOperationModel, ConnectorModel connectorModel) {
        return connectorModel.getOperations().stream().anyMatch(op -> op.getPath().equalsIgnoreCase(apiOperationModel.getPath()) && op.getHttpMethod().name().equalsIgnoreCase(apiOperationModel.getHttpMethod()));
    }

    public static APIOperationModel getApiOperation(APIModel apiModel, TriggerDescriptor triggerDescriptor) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(triggerDescriptor.getPath())).filter(x -> x.getHttpMethod().equalsIgnoreCase(triggerDescriptor.getMethod().getName())).findFirst().orElse(null);
    }

    public static OperationDescriptor getOperationDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperation) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperation.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperation.getHttpMethod())).findFirst().orElse(null);
    }

    public static List<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderReferenceDescriptors(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).flatMap(x -> ValidationUtils.getValueProviderReferenceDescriptors(x).stream()).collect(Collectors.toList());
    }

    public static List<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderBodyLevelReferenceDescriptors(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).flatMap(x -> ValidationUtils.getValueProviderBodyLevelReferenceDescriptors(x).stream()).collect(Collectors.toList());
    }

    public static List<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderReferenceDescriptors(OperationDescriptor operationDescriptor) {
        return ValidationUtils.getAllParameters(operationDescriptor.getExpects()).stream().map(ParameterDescriptor::getValueProvider).filter(x -> x instanceof ResolverReferenceDescriptor).map(x -> (ResolverReferenceDescriptor)x).collect(Collectors.toList());
    }

    public static List<ResolverReferenceDescriptor<SampleDataDefinitionDescriptor>> getSampleDataReferenceDescriptors(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).map(x -> ValidationUtils.getSampleDataReferenceDescriptor(x)).filter(x -> x != null).collect(Collectors.toList());
    }

    public static ResolverReferenceDescriptor<SampleDataDefinitionDescriptor> getSampleDataReferenceDescriptor(OperationDescriptor operationDescriptor) {
        ResolverExpressionDescriptor sampleDataExpressionDescriptor = operationDescriptor.getSampleDataExpressionDescriptor();
        if (sampleDataExpressionDescriptor instanceof ResolverReferenceDescriptor) {
            return (ResolverReferenceDescriptor)sampleDataExpressionDescriptor;
        }
        return null;
    }

    public static List<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderBodyLevelReferenceDescriptors(OperationDescriptor operationDescriptor) {
        return ValidationUtils.getAllFields(operationDescriptor.getExpects()).stream().map(FieldDescriptor::getValueProviders).filter(x -> x instanceof ResolverReferenceDescriptor).map(x -> (ResolverReferenceDescriptor)x).collect(Collectors.toList());
    }

    public static APIOperationModel getApiOperationModel(APIModel apiModel, EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(endpointDescriptor.getPath())).filter(x -> x.getHttpMethod().equalsIgnoreCase(operationDescriptor.getMethod())).findFirst().orElse(null);
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private static List<ParameterDescriptor> getAllParameters(RequestDescriptor requestDescriptor) {
        ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
        if (requestDescriptor != null) {
            parameters.addAll(requestDescriptor.getUriParameter());
            parameters.addAll(requestDescriptor.getQueryParameter());
            parameters.addAll(requestDescriptor.getHeader());
        }
        return parameters;
    }

    private static List<FieldDescriptor> getAllFields(RequestDescriptor requestDescriptor) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        if (requestDescriptor != null && requestDescriptor.getBody() != null) {
            fields.addAll(requestDescriptor.getBody().getFieldDescriptors());
        }
        return fields;
    }
}

