/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.List;
import java.util.stream.Collectors;

public class AtLeastOneSupportedSecuritySchemeRule
extends ConnectorModelValidationRule {
    public AtLeastOneSupportedSecuritySchemeRule() {
        super("At least one of the declared security schemes must be supported", "When the API spec declares security, at least one of the declared security schemes must be supported.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        return apiModel.getOperationsModel().stream().filter(opm -> ValidationUtils.apiOperationIsPresentInConnectorModel(opm, connectorModel)).filter(this::allSecuritySchemesUnsupported).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean allSecuritySchemesUnsupported(APIOperationModel apiOperationModel) {
        return !apiOperationModel.getSecuritySchemesModel().isEmpty() && apiOperationModel.getSecuritySchemesModel().stream().allMatch(x -> x.getSecuritySchemeType().equals((Object)APISecuritySchemeType.NOT_SUPPORTED));
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String detail = "API Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod() + " declares unsupported security schemes";
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }
}

