/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TriggerPathAndMethodMustExistInApiRule
extends DescriptorValidationRule {
    public TriggerPathAndMethodMustExistInApiRule() {
        super("Trigger PATH and METHOD must exist in the API specification.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        List triggerDescriptors = connectorDescriptor.getTriggers();
        if (triggerDescriptors != null && !triggerDescriptors.isEmpty()) {
            return triggerDescriptors.stream().filter(x -> !TriggerPathAndMethodMustExistInApiRule.hasMatchingOperation(apiModel, x)).map(this::getValidationError).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean hasMatchingOperation(APIModel apiModel, TriggerDescriptor triggerDescriptor) {
        if (StringUtils.isEmpty((CharSequence)triggerDescriptor.getPath()) || triggerDescriptor.getMethod() == null) {
            return true;
        }
        return ValidationUtils.getApiOperation(apiModel, triggerDescriptor) != null;
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor) {
        String detail = "Trigger with PATH: '" + triggerDescriptor.getPath() + "' and METHOD: '" + triggerDescriptor.getMethod().getName().toUpperCase() + "' does not exist in the API spec";
        return new ValidationResult(this, detail, triggerDescriptor.getLocation());
    }
}

