/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class OperationIdentifierScriptMustNotRepeatRule
extends ConnectorModelValidationRule {
    public OperationIdentifierScriptMustNotRepeatRule() {
        super("Operation identifiers must not be repeated", "There are operations with the same 'operationIdentifier'", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        HashMap operationIdentifiers = new HashMap();
        for (ConnectorOperation op : connectorModel.getOperations()) {
            if (!operationIdentifiers.containsKey(op.getOperationIdentifier())) {
                operationIdentifiers.put(op.getOperationIdentifier(), new ArrayList());
            }
            ((List)operationIdentifiers.get(op.getOperationIdentifier())).add(op);
        }
        List<ValidationResult> errors = operationIdentifiers.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> this.getValidationErrors((String)entry.getKey(), (List)entry.getValue())).flatMap(Collection::stream).collect(Collectors.toList());
        return errors;
    }

    private List<ValidationResult> getValidationErrors(String collideOperationIdentifier, List<ConnectorOperation> ops) {
        List<ValidationResult> partialErrors = ops.stream().map(op -> {
            String detail;
            if (op.isAdapter()) {
                detail = String.format("The operation [%s] identifier is already defined.", op.getOperationIdentifier());
            } else {
                String operationName = op.getHttpMethod() + ":" + op.getPath();
                detail = String.format("The operation [%s] has an 'operationIdentifier: %s' value that's already defined.", operationName, collideOperationIdentifier);
            }
            DescriptorElementLocation loc = DescriptorElementLocation.builder().empty();
            return new ValidationResult(this, detail, loc);
        }).collect(Collectors.toList());
        return partialErrors;
    }
}

