/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ParameterIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.weave.v2.parser.phase.CompilationException;

public class ParameterIdentifierScriptMustCompileRule
extends DescriptorValidationRule {
    public ParameterIdentifierScriptMustCompileRule() {
        super("Parameter identifier expression is incorrect", String.format("The 'parameterIdentifier' must be revisited (available bindings are '%s')", Arrays.toString(ParameterIdentifierExpressionHandler.IMPLICIT_INPUTS)), ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>();
        ExpressionDescriptor parameterIdentifier = connectorDescriptor.getParameterIdentifier();
        if (parameterIdentifier != null) {
            String expression = parameterIdentifier.getExpression();
            try {
                new ParameterIdentifierExpressionHandler(expression);
            }
            catch (CompilationException e) {
                result.add(this.getValidationError(connectorDescriptor, e));
            }
        }
        return result;
    }

    private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor, CompilationException e) {
        String detail = "Expression in 'parameterIdentifier' is not valid, error: \n" + e.getMessage();
        return new ValidationResult(this, detail, connectorDescriptor.getParameterIdentifier().getLocation());
    }
}

