/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.RequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PagedParametersMustNotBeIgnoredRule
extends DescriptorValidationRule {
    public PagedParametersMustNotBeIgnoredRule() {
        super("for pageNumberPagination the queryParameter page_number can be ignored ", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (APIOperationModel apiOperation : apiModel.getOperationsModel()) {
            RequestDescriptor requestDescriptor;
            OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperation);
            PaginationDeclarationDescriptor paginationDeclaration = this.getPaginationDeclaration(operationDescriptor, connectorDescriptor);
            if (paginationDeclaration == null || !PaginationType.PAGE_NUMBER.getName().equalsIgnoreCase(paginationDeclaration.getType()) || (requestDescriptor = operationDescriptor.getExpects()) == null) continue;
            List parameters = requestDescriptor.getQueryParameter();
            for (ParameterDescriptor parameter : parameters) {
                if (!parameter.getParamName().equals(paginationDeclaration.getPaginationParameterName()) || parameter.isIgnored() == null || !parameter.isIgnored().booleanValue()) continue;
                validationResults.add(this.getValidationError(apiOperation, parameter, paginationDeclaration.getName(), parameter.getParamName(), paginationDeclaration.getType()));
            }
        }
        return validationResults;
    }

    private PaginationDeclarationDescriptor getPaginationDeclaration(OperationDescriptor operationDescriptor, ConnectorDescriptor connectorDescriptor) {
        PaginationDeclarationDescriptor paginationDescriptor = null;
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getPagination())) {
            paginationDescriptor = connectorDescriptor.getPaginations().stream().filter(x -> x.getName().equalsIgnoreCase(operationDescriptor.getPagination())).findFirst().orElse(null);
        }
        return paginationDescriptor;
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel, ParameterDescriptor paramDescriptor, String namePagination, String parameterName, String typePagination) {
        String detail = "API Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().toUpperCase() + " use Pagination " + namePagination + " with a parameter with name " + parameterName + " which was ignored and is required for type pagination " + typePagination + ".";
        return new ValidationResult(this, detail, paramDescriptor.getLocation());
    }
}

