/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.connectormodelbuilder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.List;
import java.util.stream.Collectors;

public class BaseTriggerMustExistRule
extends DescriptorConnectorModelBuilderValidationRule {
    public BaseTriggerMustExistRule() {
        super("Base Trigger must exist", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        return connectorDescriptor.getTriggers().stream().filter(triggerDescriptor -> triggerDescriptor.getBase() != null).filter(triggerDescriptor -> !this.baseTriggerExist((TriggerDescriptor)triggerDescriptor, connectorDescriptor) && !this.baseTriggerExist((TriggerDescriptor)triggerDescriptor, connectorModelBuilder)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean baseTriggerExist(TriggerDescriptor triggerDescriptor, ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getTriggers().stream().anyMatch(trigger -> triggerDescriptor.getBase().equals(trigger.getName()));
    }

    private boolean baseTriggerExist(TriggerDescriptor triggerDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        return connectorModelBuilder.getTriggerBuildersByName(triggerDescriptor.getBase()).isPresent();
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor) {
        String detail = "Trigger with name: '" + triggerDescriptor.getName() + "' defines a base trigger: '" + triggerDescriptor.getBase() + "' that does not exist";
        return new ValidationResult(this, detail, triggerDescriptor.getLocation());
    }
}

