/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorSecurityKind;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeBaseDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import static org.apache.commons.lang3.StringUtils.EMPTY;
import static java.lang.String.join;

public class MockedSecuritySchemeMustBeUniqueRule extends DescriptorValidationRule {

  public MockedSecuritySchemeMustBeUniqueRule() {
    super("Mocked security scheme kind must be unique.",
          EMPTY,
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {

    List<ValidationResult> validationsResults = new ArrayList<>();
    List<SecuritySchemeBaseDescriptor> mockedSecuritySchemes =
        connectorDescriptor.getSecurity().stream()
            .filter(x -> x.getKind().equals(DescriptorSecurityKind.MOCKED))
            .collect(Collectors.toList());
    if (mockedSecuritySchemes.size() > 1) {
      validationsResults
          .add(getValidationError(mockedSecuritySchemes));
    }
    return validationsResults;
  }

  private ValidationResult getValidationError(List<SecuritySchemeBaseDescriptor> mockedSecuritySchemes) {
    String detail =
        "Security schemes found: '"
            + join(",", mockedSecuritySchemes.stream().map(x -> x.getName()).collect(Collectors.toList()))
            + "'.";
    return new ValidationResult(this, detail, mockedSecuritySchemes.get(0).getLocation());
  }


}
