/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class OperationInternalNameMustNotRepeatRule
extends ConnectorModelValidationRule {
    public OperationInternalNameMustNotRepeatRule() {
        super("Operation's internalName must not be repeated among operations.", "The internal name in some operations, used for java classes generation and generated from 'operationIdentifier' script, is colliding. Please re-arrange the 'operationIdentifier' script accordingly to avoid collisions", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        HashMap internalNames = new HashMap();
        for (ConnectorOperation op : connectorModel.getOperations()) {
            if (!internalNames.containsKey(op.getInternalName())) {
                internalNames.put(op.getInternalName(), new ArrayList());
            }
            ((List)internalNames.get(op.getInternalName())).add(op);
        }
        List<ValidationResult> validationResults = internalNames.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> this.getValidationError((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
        return validationResults;
    }

    private ValidationResult getValidationError(String internalName, List<ConnectorOperation> operations) {
        String repeatedInternalNameOps = operations.stream().map(op -> String.format("%s:%s with operation identifier [%s]", op.getHttpMethod(), op.getPath(), op.getOperationIdentifier())).collect(Collectors.joining("\n"));
        String detail = String.format("The following operations generated the same internal name [%s] from the operationIdentifier, please revisit the script 'operationIdentifier'.\n%s", internalName, repeatedInternalNameOps);
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }
}

