/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.metadata.MediaType;

public class DescriptorOperationMultipartResponseNotSupportedRule
extends DescriptorValidationRule {
    private static final List<String> multipartMediaTypes = new ArrayList<String>(){
        {
            this.add(MediaType.MULTIPART_MIXED.toString());
            this.add(MediaType.MULTIPART_FORM_DATA.toString());
            this.add(MediaType.MULTIPART_RELATED.toString());
            this.add(MediaType.MULTIPART_X_MIXED_REPLACE.toString());
        }
    };

    public DescriptorOperationMultipartResponseNotSupportedRule() {
        super("Multipart response operations are not supported", "All operations declared must not return a multipart response", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        this.validateEndpointsAPI(apiModel, validationResults);
        this.validateEndpointsDescriptor(connectorDescriptor, validationResults);
        this.validateOperationAdaptersDescriptor(connectorDescriptor, validationResults);
        return validationResults;
    }

    private void validateEndpointsAPI(APIModel apiModel, List<ValidationResult> validationResults) {
        apiModel.getOperationsModel().stream().forEach(operationModel -> {
            if (operationModel.getOutputMetadataModel() != null) {
                operationModel.getOutputMetadataModel().stream().forEach(apiTypeModel -> {
                    if (apiTypeModel.getMediaType() != null && multipartMediaTypes.stream().anyMatch(multipartMediaType -> multipartMediaType.equals(apiTypeModel.getMediaType().toString()))) {
                        validationResults.add(this.getValidationError((APIOperationModel)operationModel));
                    }
                });
            }
        });
    }

    private void validateEndpointsDescriptor(ConnectorDescriptor connectorDescriptor, List<ValidationResult> validationResults) {
        connectorDescriptor.getEndpoints().stream().forEach(endPointDescriptor -> endPointDescriptor.getOperations().stream().filter(endPointOperationDescriptor -> multipartMediaTypes.stream().anyMatch(multipartMediaType -> multipartMediaType.equals(endPointOperationDescriptor.getOutputMediaType()))).forEach(endPointDescriptorOperation -> validationResults.add(this.getValidationError((OperationDescriptor)endPointDescriptorOperation, (EndPointDescriptor)endPointDescriptor))));
    }

    private void validateOperationAdaptersDescriptor(ConnectorDescriptor connectorDescriptor, List<ValidationResult> validationResults) {
        connectorDescriptor.getOperationAdapterDescriptors().stream().forEach(operationAdapterDescriptor -> {
            if (operationAdapterDescriptor.getResponseBindings() != null && operationAdapterDescriptor.getResponseBindings().getBodyBinding() != null && operationAdapterDescriptor.getResponseBindings().getBodyBinding().getContentType() != null && multipartMediaTypes.stream().anyMatch(multipartMediaType -> multipartMediaType.equals(operationAdapterDescriptor.getResponseBindings().getBodyBinding().getContentType()))) {
                validationResults.add(this.getValidationError((OperationAdapterDescriptor)operationAdapterDescriptor));
            }
        });
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor descriptorOperation) {
        String detail = "Operation adapter: " + descriptorOperation.getOperationId() + " returns a multipart response.";
        return new ValidationResult(this, detail, descriptorOperation.getLocation());
    }

    private ValidationResult getValidationError(OperationDescriptor descriptorOperation, EndPointDescriptor endPointDescriptor) {
        String detail = "Endpoint: " + descriptorOperation.getMethod() + " " + endPointDescriptor.getPath() + " returns a multipart response.";
        return new ValidationResult(this, detail, descriptorOperation.getLocation());
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String detail = "Endpoint in API spec file: " + apiOperationModel.getHttpMethod() + " " + apiOperationModel.getPath() + " returns a multipart response.";
        return new ValidationResult(this, detail, null);
    }
}

