/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.WeaveExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class IdentifiersScriptsMustNotBeEmptyRule
extends DescriptorValidationRule {
    public IdentifiersScriptsMustNotBeEmptyRule() {
        super("The identifier script expression must not be empty.", null, ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        WeaveExpressionDescriptor bodyIdentifier = connectorDescriptor.getBodyIdentifier();
        WeaveExpressionDescriptor operationIdentifier = connectorDescriptor.getOperationIdentifier();
        WeaveExpressionDescriptor parameterIdentifier = connectorDescriptor.getParameterIdentifier();
        if (this.isMissingScriptExpression(bodyIdentifier)) {
            results.add(this.getValidationError(bodyIdentifier.getLocation(), "body"));
        }
        if (this.isMissingScriptExpression(operationIdentifier)) {
            results.add(this.getValidationError(operationIdentifier.getLocation(), "operation"));
        }
        if (this.isMissingScriptExpression(parameterIdentifier)) {
            results.add(this.getValidationError(parameterIdentifier.getLocation(), "parameter"));
        }
        return results;
    }

    private boolean isMissingScriptExpression(WeaveExpressionDescriptor identifier) {
        return identifier != null && identifier.getExpression() == null;
    }

    private ValidationResult getValidationError(DescriptorElementLocation location, String property) {
        String detail = String.format("The property '%sIdentifier' must declare a script expression.", property);
        return new ValidationResult(this, detail, location);
    }
}

