/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorSecurityKind;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeBaseDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MockedSecuritySchemeMustBeUniqueRule
extends DescriptorValidationRule {
    public MockedSecuritySchemeMustBeUniqueRule() {
        super("Mocked security scheme kind must be unique.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationsResults = new ArrayList<ValidationResult>();
        List<SecuritySchemeBaseDescriptor> mockedSecuritySchemes = connectorDescriptor.getSecurity().stream().filter(x -> x.getKind().equals((Object)DescriptorSecurityKind.MOCKED)).collect(Collectors.toList());
        if (mockedSecuritySchemes.size() > 1) {
            validationsResults.add(this.getValidationError(mockedSecuritySchemes));
        }
        return validationsResults;
    }

    private ValidationResult getValidationError(List<SecuritySchemeBaseDescriptor> mockedSecuritySchemes) {
        String detail = "Security schemes found: '" + String.join((CharSequence)",", mockedSecuritySchemes.stream().map(x -> x.getName()).collect(Collectors.toList())) + "'.";
        return new ValidationResult(this, detail, mockedSecuritySchemes.get(0).getLocation());
    }
}

