/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RequiredParametersMustNotBeIgnoredRule
extends DescriptorValidationRule {
    public RequiredParametersMustNotBeIgnoredRule() {
        super("Required operation parameters must not be ignored.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (EndPointDescriptor endPointDescriptor : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operationDescriptor : endPointDescriptor.getOperations()) {
                if (operationDescriptor.getExpects() == null) continue;
                results.addAll(this.validateParametersAreRequiredAndIgnored(operationDescriptor.getExpects().getUriParameter(), ParameterType.URI, endPointDescriptor.getPath(), operationDescriptor.getMethod(), apiModel));
                results.addAll(this.validateParametersAreRequiredAndIgnored(operationDescriptor.getExpects().getQueryParameter(), ParameterType.QUERY, endPointDescriptor.getPath(), operationDescriptor.getMethod(), apiModel));
                results.addAll(this.validateParametersAreRequiredAndIgnored(operationDescriptor.getExpects().getHeader(), ParameterType.HEADER, endPointDescriptor.getPath(), operationDescriptor.getMethod(), apiModel));
            }
        }
        return results;
    }

    private List<ValidationResult> validateParametersAreRequiredAndIgnored(List<ParameterDescriptor> parameters, ParameterType parameterType, String path, String method, APIModel apiModel) {
        return parameters.stream().filter(parameterDescriptor -> parameterDescriptor.isIgnored() != null && parameterDescriptor.isIgnored() != false).filter(parameterDescriptor -> this.parameterIsRequired((ParameterDescriptor)parameterDescriptor, parameterType, path, method, apiModel)).map(parameterDescriptor -> this.getValidationError(path, method, (ParameterDescriptor)parameterDescriptor, parameterType)).collect(Collectors.toList());
    }

    private boolean parameterIsRequired(ParameterDescriptor parameter, ParameterType parameterType, String path, String method, APIModel apiModel) {
        APIOperationModel apiOperation = ValidationUtils.getApiOperation(apiModel, path, method);
        if (apiOperation == null) {
            return false;
        }
        APIParameterModel apiParameter = ValidationUtils.getApiParameter(apiOperation, parameterType, parameter.getParamName());
        if (apiParameter == null) {
            return false;
        }
        if (ParameterType.URI.equals((Object)parameterType)) {
            return true;
        }
        return apiParameter.isRequired();
    }

    private ValidationResult getValidationError(String path, String method, ParameterDescriptor paramDescriptor, ParameterType parameterType) {
        String detail = parameterType.getName() + " '" + paramDescriptor.getParamName() + "' defined in Operation with path: " + path + " and method: " + method + " cannot be ignored as it's required.";
        return new ValidationResult(this, detail, paramDescriptor.getLocation());
    }
}

