/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorSecurityKind;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeBaseDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SecurityNotSupportedInApiMustHaveAnAssociatedCustomTypeInDescriptor
extends DescriptorValidationRule {
    public SecurityNotSupportedInApiMustHaveAnAssociatedCustomTypeInDescriptor() {
        super("Unsupported security schemes need to be customized in the connector descriptor.", "Use 'custom' type in the connector descriptor to add a custom implementation.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationsResults = new ArrayList<ValidationResult>();
        List descriptorSecurities = connectorDescriptor.getSecurity();
        List apiSecurities = this.getListOfApiSecurities(apiModel).stream().distinct().collect(Collectors.toList());
        List<APISecuritySchemeModel> apiSecuritiesNotSupportedWithNotMatchInDescriptor = this.descriptorContainsAtLeastOneAssociatedSecurity(apiModel, descriptorSecurities);
        if (!apiSecuritiesNotSupportedWithNotMatchInDescriptor.isEmpty()) {
            for (APISecuritySchemeModel apiSecuritySchemeModel : apiSecuritiesNotSupportedWithNotMatchInDescriptor) {
                validationsResults.add(this.getIsNotSupportedError(apiSecuritySchemeModel));
            }
        }
        for (APISecuritySchemeModel apiSecuritySchemeModel : apiSecurities) {
            for (SecuritySchemeBaseDescriptor descriptorSecurity : descriptorSecurities) {
                if (!this.hasAssociatedSecurityTypeInTheDescriptor(apiSecuritySchemeModel, descriptorSecurity)) continue;
                ValidationResult validationResult = this.getValidationError(apiSecuritySchemeModel, descriptorSecurity);
                if (!validationsResults.stream().noneMatch(x -> x.getDetail().equals(validationResult.getDetail()))) continue;
                validationsResults.add(this.getValidationError(apiSecuritySchemeModel, descriptorSecurity));
            }
        }
        return validationsResults;
    }

    private ValidationResult getValidationError(APISecuritySchemeModel apiSecuritySchemeModel, SecuritySchemeBaseDescriptor securitySchemeDescriptor) {
        String detail = "API Security scheme: '" + apiSecuritySchemeModel.getName() + "' was declared in the descriptor as type: '" + securitySchemeDescriptor.getKind() + "'. Only 'custom' is supported.";
        return new ValidationResult(this, detail, securitySchemeDescriptor.getLocation());
    }

    private ValidationResult getIsNotSupportedError(APISecuritySchemeModel apiSecuritySchemeModel) {
        String detail = "API Security scheme with name: " + apiSecuritySchemeModel.getName() + " is not supported nor customized in the connector descriptor.";
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }

    private boolean hasAssociatedSecurityTypeInTheDescriptor(APISecuritySchemeModel apiSecuritySchemeModel, SecuritySchemeBaseDescriptor descriptorSecurity) {
        return apiSecuritySchemeModel.getName().equals(descriptorSecurity.getName()) && apiSecuritySchemeModel.getSecuritySchemeType().equals((Object)APISecuritySchemeType.NOT_SUPPORTED) && !descriptorSecurity.getKind().equals((Object)DescriptorSecurityKind.CUSTOM) && !descriptorSecurity.getKind().equals((Object)DescriptorSecurityKind.MOCKED) || apiSecuritySchemeModel.getSecuritySchemeType().equals((Object)APISecuritySchemeType.CUSTOM) && !descriptorSecurity.getKind().equals((Object)DescriptorSecurityKind.CUSTOM) && !descriptorSecurity.getKind().equals((Object)DescriptorSecurityKind.MOCKED);
    }

    private List<APISecuritySchemeModel> descriptorContainsAtLeastOneAssociatedSecurity(APIModel apiModel, List<SecuritySchemeBaseDescriptor> descriptorSecurities) {
        ArrayList<APISecuritySchemeModel> returns = new ArrayList<APISecuritySchemeModel>();
        List<APISecuritySchemeModel> apiSecuritySchemeModels = this.getListOfApiSecurities(apiModel);
        if (!apiSecuritySchemeModels.isEmpty() && descriptorSecurities.isEmpty() && !apiSecuritySchemeModels.stream().anyMatch(x -> !x.getSecuritySchemeType().equals((Object)APISecuritySchemeType.NOT_SUPPORTED))) {
            for (APISecuritySchemeModel apiSecuritySchemeModel : apiSecuritySchemeModels) {
                if (!apiSecuritySchemeModel.getSecuritySchemeType().equals((Object)APISecuritySchemeType.NOT_SUPPORTED)) continue;
                returns.add(apiSecuritySchemeModel);
            }
        }
        return returns;
    }

    private List<APISecuritySchemeModel> getListOfApiSecurities(APIModel apiModel) {
        ArrayList<APISecuritySchemeModel> apiSecuritySchemeModels = new ArrayList<APISecuritySchemeModel>();
        for (APIOperationModel apiOperation : apiModel.getOperationsModel()) {
            for (APISecuritySchemeModel apiSecuritySchemeModel : apiOperation.getSecuritySchemesModel()) {
                if (!apiSecuritySchemeModels.stream().noneMatch(x -> x.getName().equals(apiSecuritySchemeModel.getName()))) continue;
                apiSecuritySchemeModels.add(apiSecuritySchemeModel);
            }
        }
        return apiSecuritySchemeModels;
    }
}

