/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;

public class TriggerBindingParameterMustExistInApiRule
extends DescriptorValidationRule {
    public TriggerBindingParameterMustExistInApiRule() {
        super("Parameter bindings defined in a trigger must exist in the API spec.", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List triggerDescriptors = connectorDescriptor.getTriggers();
        if (!triggerDescriptors.isEmpty()) {
            for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
                APIOperationModel operationModel = ValidationUtils.getApiOperation(apiModel, triggerDescriptor.getPath(), triggerDescriptor.getMethod() != null ? triggerDescriptor.getMethod().getName() : null);
                if (operationModel == null || triggerDescriptor.getParameterBindings() == null) continue;
                ParameterBindingsDescriptor parameterBindings = triggerDescriptor.getParameterBindings();
                this.analyzeParameters(results, triggerDescriptor, operationModel, parameterBindings.getHeaders(), ParameterType.HEADER);
                this.analyzeParameters(results, triggerDescriptor, operationModel, parameterBindings.getQueryParameters(), ParameterType.QUERY);
                this.analyzeParameters(results, triggerDescriptor, operationModel, parameterBindings.getUriParameters(), ParameterType.URI);
            }
        }
        return results;
    }

    private void analyzeParameters(List<ValidationResult> results, TriggerDescriptor triggerDescriptor, APIOperationModel operationModel, List<ParameterBindingDescriptor> bindings, ParameterType bindingParameterType) {
        if (bindings == null) {
            return;
        }
        for (ParameterBindingDescriptor binding : bindings) {
            if (this.hasMatchingParameter(operationModel, binding, bindingParameterType)) continue;
            results.add(this.getValidationError(triggerDescriptor, binding, bindingParameterType));
        }
    }

    private boolean hasMatchingParameter(APIOperationModel operationModel, ParameterBindingDescriptor binding, ParameterType parameterType) {
        List parameters = parameterType == ParameterType.HEADER ? operationModel.getHeadersModel() : (parameterType == ParameterType.QUERY ? operationModel.getQueryParamsModel() : operationModel.getUriParamsModel());
        return parameters.stream().anyMatch(x -> x.getExternalName().equalsIgnoreCase(binding.getName()));
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor, ParameterBindingDescriptor binding, ParameterType parameterType) {
        String detail = "'" + parameterType.getName() + "' parameter binding '" + binding.getName() + "' defined in Trigger with PATH: " + triggerDescriptor.getPath() + " and METHOD: " + triggerDescriptor.getMethod().getName().toUpperCase() + " declares a binding that does not exist in the API spec.";
        return new ValidationResult(this, detail, triggerDescriptor.getLocation());
    }
}

