/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.TriggerNode;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class TriggerCircularDependenciesRule
extends DescriptorValidationRule {
    public TriggerCircularDependenciesRule() {
        super("A circular dependency has been found in base triggers dependencies.", "", ValidationRule.Level.ERROR);
    }

    private TriggerNode getOrCreate(TriggerDescriptor triggerDescriptor, List<TriggerNode> createdTriggersNodesList) {
        if (triggerDescriptor != null) {
            TriggerNode node = createdTriggersNodesList.stream().filter(x -> x.getTrigger().getName().equals(triggerDescriptor.getName())).findFirst().orElse(null);
            if (node == null) {
                node = new TriggerNode(triggerDescriptor);
                createdTriggersNodesList.add(node);
            }
            return node;
        }
        return null;
    }

    private void addParent(TriggerNode triggerNode, TriggerDescriptor triggerDescriptor, ConnectorDescriptor connectorDescriptor, List<TriggerNode> createdTriggersNodesList) {
        if (triggerDescriptor.getBase() != null) {
            TriggerNode parent = this.getOrCreate(connectorDescriptor.getTriggers().stream().filter(x -> x.getName().equals(triggerDescriptor.getBase())).findFirst().orElse(null), createdTriggersNodesList);
            triggerNode.setParent(parent);
        }
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<TriggerNode> createdTriggersNodesList = new ArrayList<TriggerNode>();
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List triggerDescriptors = connectorDescriptor.getTriggers();
        if (!triggerDescriptors.isEmpty()) {
            for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
                TriggerNode node = this.getOrCreate(triggerDescriptor, createdTriggersNodesList);
                this.addParent(node, triggerDescriptor, connectorDescriptor, createdTriggersNodesList);
            }
            block1: for (TriggerNode triggerNode : createdTriggersNodesList) {
                if (triggerNode.isVisited()) continue;
                HashMap<String, Boolean> usedTriggers = new HashMap<String, Boolean>();
                usedTriggers.put(triggerNode.getTrigger().getName(), true);
                triggerNode.setVisited(true);
                for (TriggerNode pointer = triggerNode.getParent(); pointer != null; pointer = pointer.getParent()) {
                    pointer.setVisited(true);
                    if (usedTriggers.get(pointer.getTrigger().getName()) != null) {
                        results.add(this.getValidationError(usedTriggers.keySet().stream().collect(Collectors.joining(", ")), pointer.getTrigger()));
                        continue block1;
                    }
                    usedTriggers.put(pointer.getTrigger().getName(), true);
                }
            }
        }
        return results;
    }

    private ValidationResult getValidationError(String triggers, TriggerDescriptor triggerDescriptor) {
        String detail = "Triggers involved: " + triggers;
        return new ValidationResult(this, detail, triggerDescriptor.getLocation());
    }
}

