/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TriggerParameterSetAsMetadataKeyIdCannotHaveValueProviderRule
extends DescriptorValidationRule {
    public TriggerParameterSetAsMetadataKeyIdCannotHaveValueProviderRule() {
        super("Parameter defined in a trigger as MetadataKeyId cannot have a Value provider.", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
            triggerDescriptor.getParameters().stream().forEach(p -> {
                if (!StringUtils.isEmpty((CharSequence)p.getMuleMetadataKeyId()) && p.getValueProvider() != null) {
                    results.add(this.getValidationError(triggerDescriptor, (TriggerParameterDescriptor)p));
                }
            });
        }
        return results;
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor, TriggerParameterDescriptor parameter) {
        String detail = "Parameter '" + parameter.getName() + "' is set as MetadataKeyId but it also declares a Value Provider.";
        return new ValidationResult(this, detail, triggerDescriptor.getLocation());
    }
}

