/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.connectormodelbuilder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public abstract class ConnectorModelBuilderPropertyCannotBeOverridenRule
extends DescriptorConnectorModelBuilderValidationRule {
    public ConnectorModelBuilderPropertyCannotBeOverridenRule() {
        super("Property not overrideable", "Cannot set a new value for this property once set", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (this.getNotOverridablePropertyValue(connectorModelBuilder) != null && this.getPropertyValueToSet(connectorDescriptor) != null) {
            validationResults.add(new ValidationResult(this, this.getNotOverridablePropertyName() + " cannot be overridden, this is a bug", connectorDescriptor.getLocation()));
        }
        return validationResults;
    }

    protected abstract Object getNotOverridablePropertyValue(ConnectorModelBuilder var1);

    protected abstract Object getPropertyValueToSet(ConnectorDescriptor var1);

    protected abstract String getNotOverridablePropertyName();
}

