/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static java.util.stream.Collectors.toList;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;

import java.util.ArrayList;
import java.util.List;

public class DescriptorPathMustExistInApiRule extends DescriptorValidationRule {

  // R001
  public DescriptorPathMustExistInApiRule() {
    super("Descriptor PATHs must be present in the API spec",
          "Any path declared in the connector descriptor must be present in the API spec.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {

    List<String> apiPaths = apiModel.getOperationsModel().stream()
        .map(APIOperationModel::getPath)
        .distinct()
        .collect(toList());

    List<ValidationResult> validationResults = new ArrayList<>();

    for (EndPointDescriptor endPointDescriptor : connectorDescriptor.getEndpoints()) {
      if (apiPaths.stream().noneMatch(x -> x.equalsIgnoreCase(endPointDescriptor.getPath()))) {
        validationResults.add(getValidationError(endPointDescriptor));
      }
    }

    return validationResults;
  }

  private ValidationResult getValidationError(EndPointDescriptor endPointDescriptor) {
    return new ValidationResult(this,
                                "Path: " + endPointDescriptor.getPath() + " is not present in the API spec",
                                endPointDescriptor.getLocation());
  }
}
