/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.removeJavaPackageUnwantedCharacters;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.removeMavenGroupUnwantedCharacters;
import static java.lang.String.format;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class GavGroupIdMustBeValidRule extends DescriptorValidationRule {

  // R007
  public GavGroupIdMustBeValidRule() {
    super("Descriptor connectorGav's groupId must ve a valid Maven groupId",
          "The groupId defined in the connector descriptor for the connectorGav must ve a valid java package name.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {

    List<ValidationResult> validationResults = new ArrayList<>();

    MavenGavDescriptor gav = connectorDescriptor.getConnectorGav();
    if (gav == null || gav.getGroupId() == null) {
      return validationResults;
    }

    String groupId = gav.getGroupId();
    String validGroupId = removeMavenGroupUnwantedCharacters(groupId);
    String validJavaPackageGroupId = removeJavaPackageUnwantedCharacters(groupId);

    if (!groupId.equalsIgnoreCase(validGroupId) || !groupId.equalsIgnoreCase(validJavaPackageGroupId)) {
      validationResults.add(getValidationError(connectorDescriptor));
    }

    return validationResults;
  }

  private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
    String detail = format("Group Id '%s' is not a valid Maven groupId",
                           connectorDescriptor.getConnectorGav().getGroupId());

    return new ValidationResult(this, detail, connectorDescriptor.getConnectorGav().getLocation());
  }
}
