/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import static java.lang.String.format;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;

import java.util.ArrayList;
import java.util.List;

public class GavVersionMustBeValidRule extends DescriptorValidationRule {

  // R009
  public GavVersionMustBeValidRule() {
    super("Descriptor connectorGav's version must ve a valid Maven version",
          "The version defined in the connector descriptor for the connectorGav can contain numbers, dots, dashes, letters and no strange symbols.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {

    List<ValidationResult> validationResults = new ArrayList<>();

    MavenGavDescriptor gav = connectorDescriptor.getConnectorGav();
    if (gav == null || gav.getVersion() == null) {
      return validationResults;
    }

    String version = gav.getVersion();
    String validVersion = XmlUtils.removeMavenVersionUnwantedCharacters(version);

    if (!version.equalsIgnoreCase(validVersion)) {
      validationResults.add(getValidationError(connectorDescriptor));
    }

    return validationResults;
  }

  private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
    final String detail = format("Version '%s' is not a valid Maven version",
                                 connectorDescriptor.getConnectorGav().getVersion());

    return new ValidationResult(this, detail, connectorDescriptor.getConnectorGav().getLocation());
  }
}
