/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.WeaveExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class IdentifiersScriptsMustNotBeEmptyRule extends DescriptorValidationRule {


  public IdentifiersScriptsMustNotBeEmptyRule() {
    super("The identifier script expression must not be empty.", null, ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {

    List<ValidationResult> results = new ArrayList<>();

    WeaveExpressionDescriptor bodyIdentifier = connectorDescriptor.getBodyIdentifier();
    WeaveExpressionDescriptor operationIdentifier = connectorDescriptor.getOperationIdentifier();
    WeaveExpressionDescriptor parameterIdentifier = connectorDescriptor.getParameterIdentifier();

    if (isMissingScriptExpression(bodyIdentifier)) {
      results.add(getValidationError(bodyIdentifier.getLocation(), "body"));
    }
    if (isMissingScriptExpression(operationIdentifier)) {
      results.add(getValidationError(operationIdentifier.getLocation(), "operation"));
    }
    if (isMissingScriptExpression(parameterIdentifier)) {
      results.add(getValidationError(parameterIdentifier.getLocation(), "parameter"));
    }

    return results;
  }

  private boolean isMissingScriptExpression(WeaveExpressionDescriptor identifier) {
    return identifier != null && identifier.getExpression() == null;
  }

  private ValidationResult getValidationError(DescriptorElementLocation location, String property) {
    String detail = String.format("The property '%sIdentifier' must declare a script expression.", property);

    return new ValidationResult(this, detail, location);
  }
}
