/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import static org.apache.commons.lang3.StringUtils.EMPTY;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarBodyBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterResponseBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverridesBodyDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverridesRequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class OperationAdapterMaxOneMetadataKeyRule extends DescriptorValidationRule {

  public OperationAdapterMaxOneMetadataKeyRule() {
    super("Operation declares more than one metadata key.", EMPTY, ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    final List<ValidationResult> results = new ArrayList<>();

    for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
      if (hasMoreThanOneMetadataKey(operationAdapterDescriptor)) {
        results.add(getValidationError(operationAdapterDescriptor));
      }
    }
    return results;
  }

  private boolean hasMoreThanOneMetadataKey(OperationAdapterDescriptor operationAdapterDescriptor) {
    if (operationAdapterDescriptor.getBaseEndpoint() == null
        || operationAdapterDescriptor.getBaseEndpoint().getOverrides() == null) {
      return false;
    }
    OverridesRequestDescriptor overrides = operationAdapterDescriptor.getBaseEndpoint().getOverrides();
    long count =
        overrides.getQueryParameter().stream().filter(param -> param.getMetadataKey() != null).count()
            + overrides.getUriParameter().stream().filter(param -> param.getMetadataKey() != null).count()
            + overrides.getHeader().stream().filter(param -> param.getMetadataKey() != null).count();
    return count > 1;
  }

  private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor) {
    String detail = "Operation with name "
        + operationAdapterDescriptor.getOperationId()
        + " declares more than one metadata key.";

    return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
  }

}
