/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static java.lang.String.format;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

import org.mule.weave.v2.parser.phase.CompilationException;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ExpressionHandlerUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverrideResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;

import java.util.List;

public class OperationCustomFieldTransformationScriptMustCompileRule extends AbstractCustomFieldRule {

  private static final String[] IMPLICIT_INPUTS = {DWBindings.PAYLOAD.getBinding(), DWBindings.RESPONSE.getBinding()};

  public OperationCustomFieldTransformationScriptMustCompileRule() {
    super("Invalid Transformation script. The Script can only reference the 'response' binding.");
  }

  @Override
  protected void validateOverrideResolver(OperationAdapterDescriptor operationAdapterDescriptor,
                                          OverrideResolverDescriptor overrideResolver,
                                          List<ValidationResult> results) {

    if (isNotBlank(overrideResolver.getTransformationScript())) {
      try {
        ExpressionHandlerUtils.compileDataWeaveScript(overrideResolver.getTransformationScript(), IMPLICIT_INPUTS);
      } catch (CompilationException e) {
        results.add(getValidationError(operationAdapterDescriptor, e));
      }
    }
  }

  private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, CompilationException e) {
    String detail = format("Operation with name '%s' declares a transformation script that is not valid. Error: \n%s",
                           operationAdapterDescriptor.getOperationId(), e.getMessage());
    return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
  }

}
