/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.Position;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import org.apache.commons.lang3.StringUtils;

public class ValidationResult {
    private final ValidationRule rule;
    private final String detail;
    private final Location location;

    public ValidationResult(ValidationRule rule, String detail) {
        this(rule, detail, DescriptorElementLocation.EMPTY);
    }

    public ValidationResult(ValidationRule rule, String detail, DescriptorElementLocation descriptorElementLocation) {
        this.rule = rule;
        this.detail = detail;
        this.location = descriptorElementLocation != null ? new Location(descriptorElementLocation) : null;
    }

    public ValidationRule getRule() {
        return this.rule;
    }

    public ValidationRule.Level getLevel() {
        return this.rule.getLevel();
    }

    public String getDetail() {
        return this.detail;
    }

    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(String.format("[%s] Rule: %s", this.rule.getLevel().name(), this.rule.getDescription()));
        stringBuilder.append(System.lineSeparator());
        if (StringUtils.isNotBlank((CharSequence)this.rule.getExplanation())) {
            stringBuilder.append("Explanation: ").append(this.rule.getExplanation()).append(System.lineSeparator());
        }
        if (StringUtils.isNotBlank((CharSequence)this.detail)) {
            stringBuilder.append("Detail: ").append(this.detail).append(System.lineSeparator());
        }
        stringBuilder.append("Location: ").append(this.location).append(System.lineSeparator());
        return stringBuilder.toString();
    }

    public static class Location {
        private final boolean locatedInDescriptor;
        private final String file;
        private final Position start;
        private final Position end;

        public Location(DescriptorElementLocation descriptorLocation) {
            this.locatedInDescriptor = !descriptorLocation.isEmpty();
            this.file = descriptorLocation.getFile();
            this.start = descriptorLocation.getStart();
            this.end = descriptorLocation.getEnd();
        }

        public String toString() {
            if (!this.locatedInDescriptor) {
                return "File: API Specification";
            }
            int endLine = this.end.getLine();
            int startLine = this.start.getLine();
            if (this.end.getColumn() == 1) {
                --endLine;
            }
            StringBuilder sb = new StringBuilder().append("File: ").append(this.file);
            if (startLine == endLine) {
                sb.append(" (line ").append(startLine);
            } else {
                sb.append(" (lines ").append(startLine).append(" to ").append(endLine);
            }
            sb.append(")");
            return sb.toString();
        }

        public String getFile() {
            return this.file;
        }

        public Position getStart() {
            return this.start;
        }

        public Position getEnd() {
            return this.end;
        }
    }
}

