/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class BodyIdentifierScriptMustNotRepeatRule
extends ConnectorModelValidationRule {
    public BodyIdentifierScriptMustNotRepeatRule() {
        super("Body identifiers must not be repeated", "There are operations with the same 'bodyIdentifier'", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        HashMap operationIdentifiers = new HashMap();
        List operationsWithBody = connectorModel.getOperations().stream().filter(operation -> operation.getInputMetadata() != null && operation.getBody() != null && !operation.isAdapter()).collect(Collectors.toList());
        for (ConnectorOperation op : operationsWithBody) {
            if (!operationIdentifiers.containsKey(op.getBody().getBodyIdentifier())) {
                operationIdentifiers.put(op.getBody().getBodyIdentifier(), new ArrayList());
            }
            ((List)operationIdentifiers.get(op.getBody().getBodyIdentifier())).add(op);
        }
        return operationIdentifiers.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> this.getValidationErrors((String)entry.getKey(), (List)entry.getValue())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ValidationResult> getValidationErrors(String collideBodyIdentifier, List<ConnectorOperation> ops) {
        return ops.stream().map(op -> {
            String detail;
            if (op.isAdapter()) {
                detail = String.format("The operation [%s] body identifier is already defined [%s].", op.getOperationIdentifier(), collideBodyIdentifier);
            } else {
                String operationName = op.getHttpMethod() + ":" + op.getPath();
                detail = String.format("The operation [%s] has a 'bodyIdentifier: %s' value that's already defined.", operationName, collideBodyIdentifier);
            }
            return new ValidationResult(this, detail);
        }).collect(Collectors.toList());
    }
}

